/* $Id: WorkflowServiceAccessorManager.java,v 1.9 2005/08/26 04:55:52 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.client;

import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;

import org.apache.log4j.Logger;


/**
 * [Nt[T[rXANZbTAZbVPʂŊǗNXłB
 * [Nt[GWɑ΂NCAgCułB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.9 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowServiceAccessorManager {

	/** Oo̓IuWFNg */
	private static Logger log = 
		Logger.getLogger(WorkflowServiceAccessorManager.class);
	
	/** ̃NX̃CX^X */
	private static WorkflowServiceAccessorManager wsam = 
		new WorkflowServiceAccessorManager();
	
	/** 
	 * ^CAEg`FbNԊui~bjB
	 */
	private static final long CHECK_TIMEOUT_INTERVAL = 1800000L;
	
	/**
	 * ZbVLԁi~bj
	 */
	private static final long VALID_TERM = 1800000L;
	
	/** 
	 * [Nt[T[rXANZbT
	 * L[FZbVID
	 * lFManagedServiceAccessor IuWFNg
	 */ 
	private Map accessors = 
		Collections.synchronizedMap(new HashMap());
	
	/**
	 * [Nt[T[rXANZbTǗ𐶐B
	 * 
	 */
	private WorkflowServiceAccessorManager() {
		TimerTask task = new TimeoutTimerTask(this);
		new Timer().schedule(task, 0, CHECK_TIMEOUT_INTERVAL);
	}
	
	/**
	 * [Nt[T[rXANZbTǗԂB
	 *
	 */
	public static WorkflowServiceAccessorManager getInstance() {
		return wsam;
	}
	
	/**
	 * ڑgpāA[Nt[T[rXANZbT𐶐A
	 * ZbVIDPʂŕێB
	 * [Nt[T[rXANZbTł́AڑgpāA
	 * [Nt[T[rX}l[WAێB
	 * ̌A[Nt[T[rX}l[Wɑ΂āAF؂sB
	 * F؂ɐꍇ́AT[rX}l[W̎QƂێB
	 * close()Ă΂ĂȂꍇ́A܂close()sĂA
	 * ڑJȂB̏ꍇAȑÕZbVID͖ƂȂB
	 * 
	 * 
	 * @param conn ڑ
	 * @return ZbVID
	 * @throws ConnectionFailedException F؎s̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public String open(ConnectionInfo conn) 
	throws ConnectionFailedException, RemoteException {
		WorkflowServiceAccessor wsa = 
			new WorkflowServiceAccessor(conn);
		String sessionID = wsa.open();
		
		ManagedServiceAccessor msa = 
			new ManagedServiceAccessor(wsa);
		this.accessors.put(sessionID, msa);
		
		return sessionID;
	}
	
	/**
	 * ZbV𖾎IɕBAZbV̓T[o
	 * ^CAEgɂĖɂȂĂ邱ƂB
	 * ̏ꍇ́AInvalidSessionException Ԃ邪A
	 * Ă܂ȂB
	 *
	 * @throws InvalidSessionException ZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void close(String sessionID)
	throws InvalidSessionException, RemoteException {
		ManagedServiceAccessor msa = (ManagedServiceAccessor)
			this.accessors.get(sessionID);
		if (msa == null) {
			// G[bZ[WFZbVłB
			String warnMsg = StringManager.get("E8002");
			throw new InvalidSessionException(warnMsg);
		}
		try {
			msa.getServiceAccessor().close();
		
		} finally {
			// close łۂ킸ÃIuWFNg
			// Ǘ͂B
			this.accessors.remove(sessionID);
		}
	}

	/**
	 * ZbVIDɊY郏[Nt[T[rXANZbT
	 * ԂB
	 *
	 * @param sessionID ZbVID
	 * @return [Nt[T[rXANZbT
	 * @throws InvalidSessionException ZbV̏ꍇ
	 */
	public WorkflowServiceAccessor getServiceAccessor(String sessionID) 
	throws InvalidSessionException {
		ManagedServiceAccessor msa = (ManagedServiceAccessor)
			this.accessors.get(sessionID);
		if (msa == null) {
			// G[bZ[WFZbVłB
			String errMsg = StringManager.get("E8002")  
				+ "(SessionID=" + sessionID + ")";
			log.error(errMsg);
			throw new InvalidSessionException(errMsg);
		}
		return msa.getServiceAccessor();
	}
	
	/**
	 * ^C}[ɂĈ莞ԂƂɌĂяoB
	 * ^CAEgꂽZbV\[XB
	 */
	private void timerRaised() {
		// ^CAEgZbṼZbV ID 擾
		Set timeouts = new HashSet();
		for (Iterator i = accessors.keySet().iterator(); i.hasNext();) {
			String sessionID = (String) i.next();
			ManagedServiceAccessor msa 
				= (ManagedServiceAccessor) accessors.get(sessionID);
			long notAccessedTerm 
				= System.currentTimeMillis() - msa.getLastAccessedTime().getTime();
			if (notAccessedTerm >= VALID_TERM) {
				timeouts.add(sessionID);
			}
		}

		// ^CAEgZbVɑ΂鏈
		for (Iterator i = timeouts.iterator(); i.hasNext(); ) {
			// WorkflowServiceAccessor  close \bh̓GW֐ڑĂ܂
		    // ̂ŁAł͌ĂяoȂB
		    String timeoutSessionID = (String) i.next();
		    this.accessors.remove(timeoutSessionID);
		}
		
	}
	
	/**
	 * WorkflowServiceAccessor IuWFNgւ
	 * ZbV̍ŏIANZXǗ邽߂̃NXłB
	 * WorkflowServiceAccessorManager ́AWorkflowServiceAccessor
	 * IuWFNg𒼐ڊǗɁÃNX̃IuWFNgĊǗB
	 * 
	 *
	 * @author  ysahara(Argo 21, Corp.)
	 * @version $Revision: 1.9 $
	 * @since   Nautica Workflow 0.9
	 */
	private class ManagedServiceAccessor {
		
		/** ZbVŏIANZX */
		private Date lastAccessedTime;
		
		/** [Nt[T[rXANZbT */
		private WorkflowServiceAccessor wsa;
		
		private ManagedServiceAccessor(WorkflowServiceAccessor wsa) {
			this.wsa = wsa;
			// ŏIANZXɌݎݒ
			this.lastAccessedTime = new Date();
		}
		
		private WorkflowServiceAccessor getServiceAccessor() {
			this.updateLastAccessedTime();
			return this.wsa;
		}
		
		/**
		 * ZbV̍ŏIANZX擾B
		 * @return ZbVŏIANZX
		 */
		private Date getLastAccessedTime() {
			return this.lastAccessedTime;
		}
		
		/**
	     * ŏIANZXXVB
	     */
	    private void updateLastAccessedTime() {
	        this.lastAccessedTime = new Date();
	    }
	}
	
	/**
	 * ZbV^CAEgNNXłB
     * ZbVǗŕێĂ^C}ɂċNB
	 * 
	 *
	 * @author  ysahara(Argo 21, Corp.)
	 * @version $Revision: 1.9 $
	 * @since   Nautica Workflow 0.9
	 */
	private class TimeoutTimerTask extends TimerTask {
		
		private WorkflowServiceAccessorManager wam;
		
		/**
		 * TimeoutTimerTask 𐶐B
		 * 
		 * @param wam [Nt[T[rXANZX}l[W
		 */
		private TimeoutTimerTask(WorkflowServiceAccessorManager wam) {
			this.wam = wam;
		}
		
		/**
		 * [Nt[T[rXANZX}l[W̃^CAEg
		 * ̌myуZbV\[X̉ĂяoB
		 * 
		 * @see java.lang.Runnable#run()
		 */
		public void run() {
			this.wam.timerRaised();
		}
	}
}
