/* $Id: ActivityBean.java,v 1.8 2005/08/26 04:54:25 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.Timestamp;

import jp.co.argo21.nautica.workflow.wfmc.Activity;

/**
 * ̃NX́AANeBreBCX^Xe[u(ACTIVITY)ɑΉێB
 *
 * @version	$Revision: 1.8 $, $Date: 2005/08/26 04:54:25 $
 * @since	Nautica Workflow 0.9
 */
public class ActivityBean implements Activity
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** IDړ */
	static public final String ID_PREFIX  = "ACI";

	/**
	 * vZXCX^XID
	 */
	protected String procID;

	/**
	 * ANeBreBCX^XID
	 */
	protected String actID;

	/**
	 * ANeBreB`ID
	 */
	protected String actDefID;

	/**
	 * Jn
	 */
	protected Timestamp startDate;

	/**
	 * Jn
	 */
	protected String starterID;

	/**
	 * s
	 */
	protected Timestamp durationLimit;

	/**
	 * subNID
	 */
	protected String blockID;

	/**
	 * 
	 */
	protected int actState;

	/**
	 * sID
	 */
	protected String actorID;

	/**
	 * ŐVԍXV
	 */
	protected Timestamp updateDate;

	/**
	 * ANeBreBCX^XIuWFNg𐶐B
	 */
	public ActivityBean()
	{
	}

	/**
	 * vZXCX^XID擾B
	 *
	 * @return	vZXCX^XID
	 */
	public String getProcessID()
	{
		if (procID == null) return "";
		else return procID;
	}
	
	/**
	 * vZXCX^XIDݒ肷B
	 *
	 * @param	procID	vZXCX^XID
	 */
	public void setProcessID(String procID)
	{
		this.procID = procID;
	}

	/**
	 * ANeBreBCX^XID擾B
	 *
	 * @return	ANeBreBCX^XID
	 */
	public String getActivityID()
	{
		if (actID == null) return "";
		else return actID;
	}
	
	/**
	 * ANeBreBCX^XIDݒ肷B
	 *
	 * @param	actID	ANeBreBCX^XID
	 */
	public void setActivityID(String actID)
	{
		this.actID = actID;
	}

	/**
	 * ANeBreBCX^X擾B
	 *
	 * @return	ANeBreBCX^X
	 */
	public String getName()
	{
		return getProcessID() + "/" + getActivityID();
	}

	/**
	 * ANeBreB`ID擾B
	 *
	 * @return	ANeBreB`ID
	 */
	public String getActivityDefinitionID()
	{
		if (actDefID == null) return "";
		else return actDefID;
	}
	
	/**
	 * ANeBreB`IDݒ肷B
	 *
	 * @param	actDefID	ANeBreB`ID
	 */
	public void setActivityDefinitionID(String actDefID)
	{
		this.actDefID = actDefID;
	}

	/**
	 * Jn擾B
	 *
	 * @return	Jn
	 */
	public Timestamp getStartDate()
	{
		return startDate;
	}
	
	/**
	 * Jnݒ肷B
	 *
	 * @param	startDate	Jn
	 */
	public void setStartDate(Timestamp startDate)
	{
		this.startDate = startDate;
	}

	/**
	 * Jn҂擾B
	 *
	 * @return	Jn
	 */
	public String getStarterID()
	{
		if (starterID == null) return "";
		else return starterID;
	}
	
	/**
	 * Jn҂ݒ肷B
	 *
	 * @param	starterID	Jn
	 */
	public void setStarterID(String starterID)
	{
		this.starterID = starterID;
	}

	/**
	 * s擾B
	 *
	 * @return	s
	 */
	public Timestamp getDurationLimit()
	{
		return durationLimit;
	}
	
	/**
	 * sݒ肷B
	 *
	 * @param	durationLimit	s
	 */
	public void setDurationLimit(Timestamp durationLimit)
	{
		this.durationLimit = durationLimit;
	}

	/**
	 * subNID擾B
	 *
	 * @return	subNID
	 */
	public String getBlockID()
	{
		if (blockID == null) return "";
		else return blockID;
	}
	
	/**
	 * subNIDݒ肷B
	 *
	 * @param	blockID	subNID
	 */
	public void setBlockID(String blockID)
	{
		this.blockID = blockID;
	}

	/**
	 * Ԃ擾B
	 *
	 * @return	
	 */
	public int getActivityState()
	{
		return actState;
	}
	
	/**
	 * Ԃݒ肷B
	 *
	 * @param	actState	
	 */
	public void setActivityState(int actState)
	{
		this.actState = actState;
	}

	/**
	 * sID擾B
	 *
	 * @return	sID
	 */
	public String getActorID()
	{
		if (actorID == null) return "";
		else return actorID;
	}
	
	/**
	 * sIDݒ肷B
	 *
	 * @param	actorID	sID
	 */
	public void setActorID(String actorID)
	{
		this.actorID = actorID;
	}

	/**
	 * ŐVԍXV擾B
	 *
	 * @return	ŐVԍXV
	 */
	public Timestamp getUpdateDate()
	{
		return updateDate;
	}
	
	/**
	 * ŐVԍXVݒ肷B
	 *
	 * @param	updateDate	ŐVԍXV
	 */
	public void setUpdateDate(Timestamp updateDate)
	{
		this.updateDate = updateDate;
	}

	/**
	 * K[xWRN^ɂ铖YIuWFNg̉sB
	 *
	 * @throws	Throwable	Cӂ̗O
	 */
	protected void finalize() throws Throwable
	{
		// ɓƎ̉B
		super.finalize();
	}
	
	/**
	 * ̃IuWFNgƂ̔rsAꐫ𔻒肷B
	 *
	 * @param	obj	rIuWFNg
	 * @return	茋
	 */
	public boolean equals(Object obj)
	{
		boolean b = super.equals(obj);
		return b;
	}
}

