/* $Id: ActivityDAO.java,v 1.12 2005/08/26 04:54:13 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;
import java.sql.Timestamp;

import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;

/**
 * ActivityBeanf[^ƂDAOC^tF[XB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.12 $
 * @since   Nautica Workflow 0.9
 */
public interface ActivityDAO
{
	/**
	 * L[ɂAActivityBean擾B
	 *
	 * @param pid vZXID
	 * @param aid ANeBreBID
	 * @return ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public ActivityBean findByPrimaryKey(String pid, String aid)
	throws SQLException, DAOException;

	/**
	 * vZXŎw肳ꂽubNIDAs̃ANeBreB̌ԂB
	 *
	 * @param pid vZXID
	 * @param bid ubNID
	 * @return ANeBreB̌
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public int findOpeningActivityCountByBlockID(String pid, String bid)
	throws SQLException, DAOException;

	/**
	 * vZX̃ANeBreB̌ԂB
	 *
	 * @param pid vZXID
	 * @return ANeBreB̌
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public int findOpeningActivityCountByProcessID(String pid)
	throws SQLException, DAOException;

	/**
	 * vZX̃ANeBreBԂB
	 *
	 * @param pid vZXID
	 * @return ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public ActivityBean[] findOpeningActivityByProcessID(String pid)
	throws SQLException, DAOException;

	/**
	 * ubNIDɑΉubN̕sIANeBreB擾B
	 *
	 * @param pid vZXID
	 * @param adid ANeBreB`ID
	 * @param bid ubNID
	 * @return ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public ActivityBean findConcurrentEnd(String pid, String adid, String bid)
	throws SQLException, DAOException;

	/**
	 * w肳ꂽtB^[œ肳ANeBreBԂB
	 *
	 * @param filter tB^[
	 * @return ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @throws InvalidFilterException ȃtB^[w肳ꂽꍇ
	 */
	public ActivityBean[] findByFilter(Filter filter)
	throws SQLException, DAOException, InvalidFilterException;

	/**
	 * w肳ꂽvZXƃtB^[œ肳ANeBreBԂB
	 *
	 * @param pid vZXID
	 * @param filter tB^[
	 * @return ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @throws InvalidFilterException ȃtB^[w肳ꂽꍇ
	 */
	public ActivityBean[] findByFilter(String pid, Filter filter)
	throws SQLException, DAOException, InvalidFilterException;

	/**
	 * w肳ꂽ`IDƃtB^[œ肳ANeBreBԂB
	 *
	 * @param pdid vZX`ID
	 * @param adid ANeBreB`ID
	 * @param filter tB^[
	 * @return ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @throws InvalidFilterException ȃtB^[w肳ꂽꍇ
	 */
	public ActivityBean[] findByFilter(String pdid, String adid, Filter filter)
	throws SQLException, DAOException, InvalidFilterException;
	
	/**
	 * w肳ꂽANeBreB}B
	 *
	 * @param bean ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void insert(ActivityBean bean)
	throws SQLException, DAOException;
	
	/**
	 * ANeBreB̏ԂXV
	 *
	 * @param bean ANeBreB
	 * @param state ANeBreB
	 * @param ts ^CX^v
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void updateState(ActivityBean bean, ActivityState state, Timestamp ts)
	throws SQLException, DAOException;
	
	/**
	 * XVtXVB
	 *
	 * @param bean ANeBreB
	 * @param ts ^CX^v
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void updateDate(ActivityBean bean, Timestamp ts)
	throws SQLException, DAOException;
	
	/**
	 * ubNIDXVB
	 *
	 * @param bean ANeBreB
	 * @param bid ubNID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void updateBlockID(ActivityBean bean, String bid)
	throws SQLException, DAOException;
}
