/* $Id: AppExecutionDAO.java,v 1.7 2005/08/26 04:54:19 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

import jp.co.argo21.nautica.workflow.ta.ApplicationState;

/**
 * AvP[Vse[uɑ΂DAOC^tF[X
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public interface AppExecutionDAO 
{
    /**
     * L[ŁAAvP[Vse[uIuWFNg擾B
     * 
     * AvP[Vse[u̎L[łA
     * AvP[VAc[G[WFg̃NXAsIDŁA
     * AvP[Vse[uIuWFNg擾B
     *
     * @param appName		AvP[V
     * @param toolAgent		AvP[VNc[G[WFg̃NX
     * @param execID		c[G[WFgssID
     * @return		AvP[Vse[uIuWFNg
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
     */
    public AppExecutionBean findByPrimaryKey(String appName, String toolAgent, int execID)
	throws SQLException, DAOException;

	/**
	 * sIDŁAAvP[Vse[uIuWFNg擾B
	 * 
	 * L[̈ꕔłAsIDŃAvP[Vse[uIuWFNg̃Xg
	 * 擾
	 *
	 * @param execID	sID
	 * @return		AvP[Vse[uIuWFNg̃Xg
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public List findByExecID(int execID)
	throws SQLException, DAOException;
    
	/**
	 * JnIDŁAAvP[Vse[uIuWFNg擾B
	 * JnIDƂ́AΉƍIDłB
	 *
	 * @param starterID JnID
	 * @return		AvP[Vse[uIuWFNg̃Xg
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public List findByStarterID(String starterID)
	throws SQLException, DAOException;
    
	/**
	 * AvP[Vse[uɃR[hǉB
	 * 
	 * @param bean		AvP[Vse[uIuWFNg
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void insert(AppExecutionBean bean)
	throws SQLException, DAOException;

	/**
	 * sԂXV
	 *
	 * @param appName		AvP[V
	 * @param toolAgent		c[G[WFg̃NX
	 * @param execID		sID
	 * @param oldState		s
	 * @param newState		Vs
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void updateState(String appName, String toolAgent, int execID, 
	        ApplicationState oldState, ApplicationState newState)
	throws SQLException, DAOException;

	/**
	 * sԂƏIXV
	 *
	 * @param appName		AvP[V
	 * @param toolAgent		c[G[WFg̃NX
	 * @param execID		sID
	 * @param oldState		s
	 * @param newState		Vs
	 * @param newDate		VI
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void updateState(String appName, String toolAgent, int execID, 
	        ApplicationState oldState, ApplicationState newState, Timestamp newDate)
	throws SQLException, DAOException;

}
