/* $Id: ConcurrencyBlockDAO.java,v 1.6 2005/08/26 04:54:05 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;

/**
 * ConcurrencyBlockBeanf[^ƂDAOC^tF[XB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public interface ConcurrencyBlockDAO
{
	/**
	 * L[ɂAsubN擾B
	 *
	 * @param pid vZXID
	 * @param bid ubNID
	 * @return subN
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public ConcurrencyBlockBean findByPrimaryKey(String pid, String bid)
	throws SQLException, DAOException;

	/**
	 * ubÑTuubN݂̑擾B
	 *
	 * @param pid vZXID
	 * @param bid ubNID
	 * @return ݂TuubŇ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public int findSubblockExistenceByBlockID(String pid, String bid)
	throws SQLException, DAOException;

	/**
	 * vZX̃TuubN݂̑擾B
	 *
	 * @param pid vZXID
	 * @return ݂TuubŇ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public int findSubblockExistenceByProcessID(String pid)
	throws SQLException, DAOException;

	/**
	 * subN}B
	 *
	 * @param bean subN
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void insert(ConcurrencyBlockBean bean)
	throws SQLException, DAOException;

	/**
	 * subN폜B
	 *
	 * @param pid vZXID
	 * @param bid ubNID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void delete(String pid, String bid)
	throws SQLException, DAOException;
}
