/* $Id: DefinitionBean.java,v 1.8 2005/08/26 04:54:07 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * DEFINITIONe[uɑΉێNXłB
 *<pre><tt>
 * ID        ږ             ^       o m
 * ------------------------------------------------------------------
 * PROC_DEF_ID   vZX`ID       64  		
 * PATH          `΃pX        128    		
 * INTERNAL_PDID vZX`ID   64    		
 * REGISTER_DATE o^             t          		
 * DEF_STATE     `           l     1     enable/diable
 * </tt></pre>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class DefinitionBean implements Serializable
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** ` */
	private String processDefinitionID;
	/** `΃pX */
	private String path;
	/** vZX`ID */
	private String internalPDID;
	/** o^ */
	private Timestamp registerDate;
	/** ` */
	private int state;
	
	/**
	 * 	`IuWFNg𐶐B
	 *
	 */
	public DefinitionBean() {
	}
		
	/**
	 * processDefinitionIDԂB
	 *
	 * @return processDefinitionID̒l
	 */
	public String getProcessDefinitionID()
	{
		return processDefinitionID;
	}

	/**
	 * pathԂB
	 *
	 * @return path̒l
	 */
	public String getPath()
	{
		return path;
	}
	/**
	 * internalPDIDԂB
	 *
	 * @return internalPDID̒l
	 */
	public String getInternalPDID()
	{
		return internalPDID;
	}

	/**
	 * registerDateԂB
	 *
	 * @return registerDate̒l
	 */
	public Timestamp getRegisterDate()
	{
		return registerDate;
	}

	/**
	 * stateԂB
	 *
	 * @return state̒l
	 */
	public int getState()
	{
		return state;
	}

	/**
	 * processDefinitionIDݒ肷B
	 * 
	 * @param processDefinitionID processDefinitionIDւ̐ݒl
	 */
	public void setProcessDefinitionID(String processDefinitionID)
	{
		this.processDefinitionID = processDefinitionID;
	}
	
	/**
	 * pathݒ肷B
	 * 
	 * @param path pathւ̐ݒl
	 */
	public void setPath(String path)
	{
		this.path = path;
	}

	/**
	 * internalPDIDݒ肷B
	 * 
	 * @param internalPDID internalPDIDւ̐ݒl
	 */
	public void setInternalPDID(String internalPDID)
	{
		this.internalPDID = internalPDID;
	}
	
	/**
	 * registerDateݒ肷B
	 * 
	 * @param registerDate registerDateւ̐ݒl
	 */
	public void setRegisterDate(Timestamp registerDate)
	{
		this.registerDate = registerDate;
	}
	
	/**
	 * stateݒ肷B
	 * 
	 * @param state stateւ̐ݒl
	 */
	public void setState(int state)
	{
		this.state = state;
	}
}
