/* $Id: DefinitionDAO.java,v 1.11 2005/08/26 04:54:17 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;
import java.util.List;

import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;

/**
 * `Ǘe[uɑ΂DAOC^tF[X
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.11 $
 * @since   Nautica Workflow 0.9
 */
public interface DefinitionDAO
{
	/**
	 * L[ɂA`擾B
	 *
	 * @param pdid `ID
	 * @return `
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public DefinitionBean findByPrimaryKey(String pdid)
	throws SQLException, DAOException;

	/**
	 * pXƃvZX`IDŒ`擾B
	 *
	 * @param path `t@Cւ̑΃pX
	 * @param ipdid vZX`ID
	 * @return `
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public DefinitionBean findByPathAndID(String path, String ipdid)
	throws SQLException, DAOException;

	/**
	 * tB^[ɂ肳ꂽ`擾B
	 *
	 * @param filter tB^[
	 * @return `
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @throws InvalidFilterException ȃtB^[w肳ꂽꍇ
	 */
	public List findByFilter(Filter filter)
	throws SQLException, DAOException, InvalidFilterException;

	/**
	 * `}B
	 *
	 * @param bean `
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void insert(DefinitionBean bean)
	throws SQLException, DAOException;

	/**
	 * `̏ԂXVB
	 *
	 * @param pdid `ID
	 * @param oldState Ȍ
	 * @param newState ̏
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void updateState(String pdid, int oldState, int newState)
	throws SQLException, DAOException;
}
