/* $Id: OrganizationManagerDAO.java,v 1.4 2005/08/26 04:54:23 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;

/**
 * OrganizationManagerDAÓAgDǗ֘ÅeAPI`B
 * iĂf[^ɃANZX邽߂̃C^tF[XłB
 * ۂɂ́ACӂ̑gDǗVXe𗘗p邽߂ɁA
 * ̃C^tF[X𗘗p̎pӂȂ΂ȂȂB
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public interface OrganizationManagerDAO {

    /**
     * w肳ꂽgDID̑gDԂB
     * YgD񂪑݂Ȃꍇ null ԂB
     * 
     * @param  oid gDID
     * @return w肳ꂽgDID̏OrganizationBean
     * @throws SQLException
     * @throws DAOException
     */
    public OrganizationBean findByOrganizationID(String oid)
    throws SQLException, DAOException;
    
    /**
     * w肳ꂽgD̃[U̔zԂB
     * Y郆[U񂪑݂Ȃꍇ͋̔zԂB
     * 
     * @param  oid gDID
     * @return w肳ꂽgDɏ郆[UUserBean̔z
     * @throws SQLException
     * @throws DAOException
     */
    public UserBean[] findUsersByOrganizationID(String oid)
	throws SQLException, DAOException;
    
    /**
     * w肳ꂽ[ȔgD̔zԂB
     * YgD񂪑݂Ȃꍇ͋̔zԂB
     * 
     * @param  uid [UID
     * @return w肳ꂽ[UgDOrganizationBean̔z
     * @throws SQLException
     * @throws DAOException
     */
    public OrganizationBean[] findByUserID(String uid)
	throws SQLException, DAOException;
    
    /**
     * w肳ꂽgD̏ʑgDԂB
	 * YʑgD񂪑݂Ȃꍇ null ԂB
	 *
	 * @param oid gDID
	 * @return OrganizationBean
     * @throws SQLException
     * @throws DAOException
     */
    public OrganizationBean findHigherByOrganizationID(String oid)
    throws SQLException, DAOException;
}
