/* $Id: ProcessDAO.java,v 1.11 2005/08/26 04:54:00 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;
import java.sql.Timestamp;

import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * ProcessBeanf[^ƂDAOC^tF[XB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.11 $
 * @since   Nautica Workflow 0.9
 */
public interface ProcessDAO
{
	/**
	 * L[ɂAvZX擾B
	 *
	 * @param pid vZXID
	 * @return vZX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public ProcessBean findByPrimaryKey(String pid)
	throws SQLException, DAOException;

	/**
	 * vZX`IDƃvZXIDvZX擾B
	 *
	 * @param pdid	vZX`ID
	 * @param pid vZXID
	 * @return vZX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public ProcessBean findByPDIDandPID(String pdid, String pid)
	throws SQLException, DAOException;
	
	/**
	 * vZX`IDɈvvZX擾B
	 *
	 * @param pdid	vZX`ID
	 * @return vZX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public ProcessBean[] findByPDID(String pdid)
	throws SQLException, DAOException;
		
	/**
	 * vZX`IDɈvvZX̌ԂB
	 *
	 * @param pdid	vZX`ID
	 * @return vZX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public int findCountByPDID(String pdid)
	throws SQLException, DAOException;

	/**
	 * tB^[ɈvvZXԂB
	 *
	 * @param filter tB^[
	 * @return vZX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @throws InvalidFilterException
	 */
	public ProcessBean[] findByFilter(Filter filter)
	throws SQLException, DAOException, InvalidFilterException;

	/**
	 * vZX`IDƃtB^[ɈvvZXԂB
	 *
	 * @param pdid	vZX`ID
	 * @param filter tB^[
	 * @return vZX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @throws InvalidFilterException
	 */
	public ProcessBean[] findByFilter(String pdid, Filter filter)
	throws SQLException, DAOException, InvalidFilterException;
	
	/**
	 * vZX}B
	 *
	 * @param bean vZX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void insert(ProcessBean bean)
	throws SQLException, DAOException;

	/**
	 * vZXXVB
	 *
	 * @param bean vZX
	 * @param name vZX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void updateName(ProcessBean bean, String name)
	throws SQLException, DAOException;
	
	/**
	 * vZXԂXVB
	 *
	 * @param bean vZX
	 * @param state vZX
	 * @param ts ^CX^v
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void updateState(ProcessBean bean, ProcessState state, Timestamp ts)
	throws SQLException, DAOException;

	/**
	 * vZXύXtXVB
	 *
	 * @param bean vZX
	 * @param ts ^CX^v
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void updateDate(ProcessBean bean, Timestamp ts)
	throws SQLException, DAOException;
}
