/* $Id: ProcessWaitActivityDAO.java,v 1.8 2005/08/26 04:54:12 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;

/**
 * ProcessWaitActivityBeanf[^ƂDAOC^tF[XB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public interface ProcessWaitActivityDAO
{
	/**
	 * IDɑΉTuvZXI҂ANeBreB擾B
	 *
	 * @param spid TuvZXID
	 * @return TuvZXI҂ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public ProcessWaitActivityBean findBySubprocessID(String spid)
	throws SQLException, DAOException;

	/**
	 * vZXIdƃANeBreBIDŃTuvZXI҂ANeBreB擾B
	 *
	 * @param pid vZXID
	 * @param aid ANeBreBID
	 * @return TuvZXI҂ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public ProcessWaitActivityBean findByProcIDANDActID(String pid, String aid)
	throws SQLException, DAOException;

	/**
	 * TuvZXI҂ANeBreB}B
	 *
	 * @param bean TuvZXI҂ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void insert(ProcessWaitActivityBean bean)
	throws SQLException, DAOException;

	/**
	 * TuvZXI҂ANeBreB폜B
	 *
	 * @param spid TuvZXID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void delete(String spid)
	throws SQLException, DAOException;
}
