/* $Id: RoleBean.java,v 1.4 2005/08/26 04:54:09 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.util.HashMap;
import java.util.Map;

import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.wfmc.Participant;

/**
 * ̃NX́Aێ
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class RoleBean implements Role {
    /** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;
	
    private String id;
    private String name;
    private Map attributes = new HashMap();
    private int type = Participant.ROLE;
    
    /**
     * IuWFNg𐶐B
     *
     */
    public RoleBean() {
        // ȂB
    }
    
    /**
     * IDԂB
     * 
     * @return ID
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#getID()
     */
    public String getID() {
        return id;
    }
    
    /**
     * IDݒ肷B
     * 
     * @param id ID
     */
    public void setID(String id) {
        this.id = id;
    }

    /**
     * ԂB
     * 
     * @return 
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#getName()
     */
    public String getName() {
        return name;
    }

    /**
     * ݒ肷B
     * 
     * @param name 
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * QҌ^ԂB
	 * 
	 * @return	QҌ^
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#getType()
     */
    public int getType() {
        return type;
    }
    
    /**
     * ێ鑮ԂB
	 *
	 * @param  name 
	 * @return l
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#getAttribute(java.lang.String)
     */
    public String getAttribute(String name) {
        return (String) attributes.get(name);
    }

    /**
     * ݒ肷B
	 *
	 * @param name  
	 * @param value l
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#setAttribute(java.lang.String, java.lang.String)
     */
    public void setAttribute(String name, String value) {
        attributes.put(name, value);
    }

    /**
     * ێ邷ׂĂ̑ԂB
	 *
	 * @return ̈ꗗ
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#getAllAttributeNames()
     */
    public String[] getAllAttributeNames() {
        return (String[]) attributes.keySet().toArray(new String[attributes.size()]);
    }
}