/* $Id: UserBean.java,v 1.8 2005/08/26 04:54:26 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.wfmc.Participant;

/**
 * ̃NX́A[Uێ
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class UserBean implements User {
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

    private String id;
    private String firstname;
    private String lastname;
    private Map attributes = new HashMap();
    private int type = Participant.HUMAN;
    
    /**
     * [UIuWFNg𐶐B
     *
     */
    public UserBean() {
        // ȂB
    }
    
    /**
     * [UIDԂB
     * 
     * @return [UID
     * @see jp.co.argo21.nautica.workflow.security.User#getID()
     */
    public String getID() {
        return id;
    }
    
    /**
     * [UIDݒ肷B
     * 
     * @param id [UID
     */
    public void setID(String id) {
        this.id = id;
    }

    /**
     * [UԂB
     * 
     * @return [U
     * @see jp.co.argo21.nautica.workflow.security.User#getName()
     */
    public String getName() {
    	if (Locale.getDefault().toString().equals("ja_JP")) {
            return lastname + " " + firstname;
    	} else {
    		return firstname + ", " + lastname;
    	}
    }
    
    /**
     * [Ũt@[Xgl[ݒ肷B
     * 
     * @param firstname t@[Xgl[
     */
    public void setFirstName(String firstname) {
        this.firstname = firstname;
    }
    
    /**
     * [ŨXgl[ݒ肷B
     * 
     * @param lastname Xgl[
     */
    public void setLastName(String lastname) {
        this.lastname = lastname;
    }
    
    /**
     * QҌ^ԂB
	 * 
	 * @return	QҌ^
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#getType()
     */
    public int getType() {
        return type;
    }

    /**
     * ێ鑮ԂB
	 *
	 * @param  name 
	 * @return l
     * @see jp.co.argo21.nautica.workflow.security.User#getAttribute(java.lang.String)
     */
    public String getAttribute(String name) {
        return (String) attributes.get(name);
    }

    /**
     * ݒ肷B
	 *
	 * @param name  
	 * @param value l
     * @see jp.co.argo21.nautica.workflow.security.User#setAttribute(java.lang.String, java.lang.String)
     */
    public void setAttribute(String name, String value) {
        attributes.put(name, value);
    }

    /**
     * ێ邷ׂĂ̑ԂB
	 *
	 * @return ̈ꗗ
     * @see jp.co.argo21.nautica.workflow.security.User#getAllAttributeNames()
     */
    public String[] getAllAttributeNames() {
        return (String[]) attributes.keySet().toArray(new String[attributes.size()]);
    }
}
