/* $Id: VariableDAO.java,v 1.10 2005/08/26 04:54:18 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

/**
 * VariableBeanf[^ƂDAOC^tF[XB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.10 $
 * @since   Nautica Workflow 0.9
 */
public interface VariableDAO
{
	/**
	 * vZXIDƃvZXϐIDŃvZXϐ擾B
	 *
	 * @param pid vZXID
	 * @param vid vZXϐID
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public VariableBean findByPrimaryKey(String pid, String vid)
	throws SQLException, DAOException;

	/**
	 * vZXIDƃvZXϐ`IDŃvZXϐ擾B
	 *
	 * @param pid vZXID
	 * @param vdid vZXϐ`ID
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public VariableBean findByDefinitionID(String pid, String vdid)
	throws SQLException, DAOException;

	/**
	 * vZXIDƃvZXϐŃvZXϐ擾B
	 *
	 * @param pid vZXID
	 * @param name vZXϐ
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public VariableBean findByName(String pid, String name)
	throws SQLException, DAOException;

	/**
	 * vZXIDƃvZXϐIDŃvZXϐ擾B
	 *
	 * @param pid vZXID
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public VariableBean[] findByProcessID(String pid)
	throws SQLException, DAOException;

	/**
	 * XgƂăvZXID^B
	 *
	 * @param pid vZXID
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public List findByProcessIDAsList(String pid)
	throws SQLException, DAOException;
	
	/**
	 * vZXIDSQLŃvZXϐ擾B
	 *
	 * @param pid vZXID
	 * @param sqlPart SQL
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public VariableBean[] findBySQLPart(String pid, String sqlPart)
	throws SQLException, DAOException;

	/**
	 * vZXϐ}B
	 *
	 * @param bean vZXϐ
	 * @param aid ANeBreBID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void insert(VariableBean bean, String aid)
	throws SQLException, DAOException;
	
	/**
	 * vZXϐXVB
	 *
	 * @param bean vZXϐ
	 * @param value l̕\
	 * @param aid ANeBreBID
	 * @param ts ^CX^v
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void update(VariableBean bean, String value, String aid, Timestamp ts)
	throws SQLException, DAOException;
}
