/* $Id: WorkItemBean.java,v 1.7 2005/08/26 04:54:12 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import jp.co.argo21.nautica.workflow.wfmc.WorkItem;

/**
 * ̃NX́Aƍڃe[u(WORK_ITEM)ɑΉێB
 *
 * @version	$Revision: 1.7 $, $Date: 2005/08/26 04:54:12 $
 * @since	Nautica Workflow 0.9
 */
public class WorkItemBean implements WorkItem
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** IDړ */
	static public final String ID_PREFIX  = "WII";
	/**
	 * ƍID
	 */
	protected String workID;

	/**
	 * vZXCX^XID
	 */
	protected String procID;

	/**
	 * ANeBreBCX^XID
	 */
	protected String actID;

	/**
	 * [Nt[QҌ^
	 */
	protected int participantType;

	/**
	 * [Nt[QҖ
	 */
	protected String participantName;

	/**
	 * ƍڃIuWFNg𐶐B
	 */
	public WorkItemBean()
	{
	}

	/**
	 * ƍID擾B
	 *
	 * @return	ƍID
	 */
	public String getID()
	{
		if (workID == null) return "";
		else return workID;
	}
	
	/**
	 * ƍIDݒ肷B
	 *
	 * @param	workID	ƍID
	 */
	public void setID(String workID)
	{
		this.workID = workID;
	}

	/**
	 * vZXCX^XID擾B
	 *
	 * @return	vZXCX^XID
	 */
	public String getProcessID()
	{
		if (procID == null) return "";
		else return procID;
	}
	
	/**
	 * vZXCX^XIDݒ肷B
	 *
	 * @param	procID	vZXCX^XID
	 */
	public void setProcessID(String procID)
	{
		this.procID = procID;
	}

	/**
	 * ANeBreBCX^XID擾B
	 *
	 * @return	ANeBreBCX^XID
	 */
	public String getActivityID()
	{
		if (actID == null) return "";
		else return actID;
	}
	
	/**
	 * ANeBreBCX^XIDݒ肷B
	 *
	 * @param	actID	ANeBreBCX^XID
	 */
	public void setActivityID(String actID)
	{
		this.actID = actID;
	}

	/**
	 * ƍږ擾B
	 *
	 * @return	ƍږ
	 */
	public String getName()
	{
		return getProcessID() + "/" + getActivityID();
	}

	/**
	 * [Nt[QҌ^擾B
	 *
	 * @return	[Nt[QҌ^
	 */
	public int getParticipantType()
	{
		return participantType;
	}
	
	/**
	 * [Nt[QҌ^ݒ肷B
	 *
	 * @param	participantType	[Nt[QҌ^
	 */
	public void setParticipantType(int participantType)
	{
		this.participantType = participantType;
	}

	/**
	 * [Nt[QҖ̂擾B
	 *
	 * @return	[Nt[QҖ
	 */
	public String getParticipantName()
	{
		if (participantName == null) return "";
		else return participantName;
	}
	
	/**
	 * [Nt[QҖ̂ݒ肷B
	 *
	 * @param	participantName	[Nt[QҖ
	 */
	public void setParticipantName(String participantName)
	{
		this.participantName = participantName;
	}

	/**
	 * K[xWRN^ɂ铖YIuWFNg̉sB
	 *
	 * @throws	Throwable	Cӂ̗O
	 */
	protected void finalize() throws Throwable
	{
		// ɓƎ̉B
		super.finalize();
	}
	
	/**
	 * ̃IuWFNgƂ̔rsAꐫ𔻒肷B
	 *
	 * @param	obj	rIuWFNg
	 * @return	茋
	 */
	public boolean equals(Object obj)
	{
		boolean b = super.equals(obj);
		return b;
	}
}

