/* $Id: WorkItemDAO.java,v 1.15 2005/08/26 04:54:14 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;

import jp.co.argo21.nautica.workflow.wfmc.Participant;

/**
 * WorkItemBeanf[^ƂDAOC^tF[XB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.15 $
 * @since   Nautica Workflow 0.9
 */
public interface WorkItemDAO
{
	/**
	 * ƍIDōƍڂ擾B
	 *
	 * @param wid ƍID
	 * @return ƍ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public WorkItemBean findByPrimaryKey(String wid)
	throws SQLException, DAOException;

	/**
	 * vZXIDƃANeBreBIDōƍڂ擾B
	 *
	 * @param pid vZXID
	 * @param aid ANeBreBID
	 * @return ƍ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public WorkItemBean findByProcessIDANDActivityID(String pid, String aid)
	throws SQLException, DAOException;


	/**
	 * [Nt[QҖƌ^ōƍڂ̌擾B
	 *
	 * @param name [Nt[QҖ
	 * @param type [Nt[QҌ^
	 * @return ƍڂ̌
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public int findCountByParticipant(String name, int type)
	throws SQLException, DAOException;

	/**
	 * [Nt[QҖƌ^ōƍڂ擾B
	 *
	 * @param name [Nt[QҖ
	 * @param type [Nt[QҌ^
	 * @return ƍ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public WorkItemBean[] findByParticipant(String name, int type)
	throws SQLException, DAOException;

	/**
	 * SQLɂāAƍڂ擾B
	 *
	 * @param s SQL
	 * @param hasAttributeFilter tB^[܂ޏꍇtrue
	 * @return ƍ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public WorkItemBean[] findBySQLPart(String s, boolean hasAttributeFilter)
	throws SQLException, DAOException;
	
	/**
	 * ƍڂ}B
	 *
	 * @param bean ƍ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void insert(WorkItemBean bean)
	throws SQLException, DAOException;

	/**
	 * ƍڂ̃[Nt[Q҂XVB
	 *
	 * @param wid ƍID
	 * @param src XVÕ[Nt[Q
	 * @param target XṼ[Nt[Q
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void updateParticipant(String wid,Participant src, Participant target)
	throws SQLException, DAOException;

	/**
	 * ƍڂ폜B
	 *
	 * @param wid ƍID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void delete(String wid)
	throws SQLException, DAOException;

	/**
	 * vZXIDƃANeBreBIDōƍڂ擾B
	 *
	 * @param pid vZXID
	 * @param aid ANeBreBID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 */
	public void deleteByProcessIDANDActivityID(String pid, String aid)
	throws SQLException, DAOException;
}
