/* $Id: WorkflowDAOFactory.java,v 1.10 2005/08/26 04:54:03 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.Connection;

/**
 * GWŎgpeDAO(Data Access Object)̃t@NgłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.10 $
 * @since   Nautica Workflow 0.9
 */
public interface WorkflowDAOFactory
{
	/**
	 * ActivityDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ActivityDAO
	 * @throws Exception Cӂ̗O
	 */
	public ActivityDAO getActivityDAO(Connection conn)
		throws Exception;

	/**
	 * ActivityHistoryDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ActivityHistoryDAO
	 * @throws Exception Cӂ̗O
	 */
	public ActivityHistoryDAO getActivityHistoryDAO(Connection conn)
		throws Exception;

	/**
	 * AppExecutionDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return AppExecutionDAO
	 * @throws Exception Cӂ̗O
	 */
	public AppExecutionDAO getAppExecutionDAO(Connection conn)
		throws Exception;

	/**
	 * ApplicationDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ApplicationDAO
	 * @throws Exception Cӂ̗O
	 */
	public ApplicationDAO getApplicationDAO(Connection conn)
		throws Exception;

	/**
	 * ApplicationTypeDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ApplicationTypeDAO
	 * @throws Exception Cӂ̗O
	 */
	public ApplicationTypeDAO getApplicationTypeDAO(Connection conn)
		throws Exception;

	/**
	 * ConcurrencyBlockDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ConcurrencyBlockDAO
	 * @throws Exception Cӂ̗O
	 */
	public ConcurrencyBlockDAO getConcurrencyBlockDAO(Connection conn)
		throws Exception;

	/**
	 * DefinitionDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return DefinitionDAO
	 * @throws Exception Cӂ̗O
	 */
	public DefinitionDAO getDefinitionDAO(Connection conn)
		throws Exception;

	/**
	 * ProcessDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ProcessDAO
	 * @throws Exception Cӂ̗O
	 */
	public ProcessDAO getProcessDAO(Connection conn)
		throws Exception;

	/**
	 * ProcessHistoryDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ProcessHistoryDAO
	 * @throws Exception Cӂ̗O
	 */
	public ProcessHistoryDAO getProcessHistoryDAO(Connection conn)
		throws Exception;

	/**
	 * ProcessWaitActivityDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ProcessWaitActivityDAO
	 * @throws Exception Cӂ̗O
	 */
	public ProcessWaitActivityDAO getProcessWaitActivityDAO(Connection conn)
		throws Exception;

	/**
	 * SequencerDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return SequencerDAO
	 * @throws Exception Cӂ̗O
	 */
	public SequencerDAO getSequencerDAO(Connection conn)
		throws Exception;

	/**
	 * SourceActivityDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return SourceActivityDAO
	 * @throws Exception Cӂ̗O
	 */
	public SourceActivityDAO getSourceActivityDAO(Connection conn)
		throws Exception;

	/**
	 * TargetProcessDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return TargetProcessDAO
	 * @throws Exception Cӂ̗O
	 */
	public TargetProcessDAO getTargetProcessDAO(Connection conn)
		throws Exception;

	/**
	 * VariableDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return VariableDAO
	 * @throws Exception Cӂ̗O
	 */
	public VariableDAO getVariableDAO(Connection conn)
		throws Exception;

	/**
	 * VariableHistoryDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return VariableHistoryDAO
	 * @throws Exception Cӂ̗O
	 */
	public VariableHistoryDAO getVariableHistoryDAO(Connection conn)
		throws Exception;

	/**
	 * WorkItemDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return WorkItemDAO
	 * @throws Exception Cӂ̗O
	 */
	public WorkItemDAO getWorkItemDAO(Connection conn)
		throws Exception;
	
	/**
	 * OrganizationManagerDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return OrganizationManagerDAO
	 * @throws Exception Cӂ̗O
	 */
	public OrganizationManagerDAO getOrganizationManagerDAO(Connection conn)
	    throws Exception;
	
	/**
	 * RoleManagerDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return RoleManagerDAO
	 * @throws Exception Cӂ̗O
	 */
	public RoleManagerDAO getRoleManagerDAO(Connection conn)
	    throws Exception;
	
	/**
	 * UserManagerDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return UserManagerDAO
	 * @throws Exception Cӂ̗O
	 */
	public UserManagerDAO getUserManagerDAO(Connection conn)
	    throws Exception;
	
	/**
	 * ActivityDAOԂB
	 *
	 * @return ActivityDAO
	 * @throws Exception Cӂ̗O
	 */
	public ActivityDAO getActivityDAO()
		throws Exception;

	/**
	 * ActivityHistoryDAOԂB
	 *
	 * @return ActivityHistoryDAO
	 * @throws Exception Cӂ̗O
	 */
	public ActivityHistoryDAO getActivityHistoryDAO()
		throws Exception;

	/**
	 * AppExecutionDAOԂB
	 *
	 * @return AppExecutionDAO
	 * @throws Exception Cӂ̗O
	 */
	public AppExecutionDAO getAppExecutionDAO()
		throws Exception;

	/**
	 * ApplicationDAOԂB
	 *
	 * @return ApplicationDAO
	 * @throws Exception Cӂ̗O
	 */
	public ApplicationDAO getApplicationDAO()
		throws Exception;

	/**
	 * ApplicationTypeDAOԂB
	 *
	 * @return ApplicationTypeDAO
	 * @throws Exception Cӂ̗O
	 */
	public ApplicationTypeDAO getApplicationTypeDAO()
		throws Exception;

	/**
	 * ConcurrencyBlockDAOԂB
	 *
	 * @return ConcurrencyBlockDAO
	 * @throws Exception Cӂ̗O
	 */
	public ConcurrencyBlockDAO getConcurrencyBlockDAO()
		throws Exception;

	/**
	 * DefinitionDAOԂB
	 *
	 * @return DefinitionDAO
	 * @throws Exception Cӂ̗O
	 */
	public DefinitionDAO getDefinitionDAO()
		throws Exception;

	/**
	 * ProcessDAOԂB
	 *
	 * @return ProcessDAO
	 * @throws Exception Cӂ̗O
	 */
	public ProcessDAO getProcessDAO()
		throws Exception;

	/**
	 * ProcessHistoryDAOԂB
	 *
	 * @return ProcessHistoryDAO
	 * @throws Exception Cӂ̗O
	 */
	public ProcessHistoryDAO getProcessHistoryDAO()
		throws Exception;

	/**
	 * ProcessWaitActivityDAOԂB
	 *
	 * @return ProcessWaitActivityDAO
	 * @throws Exception Cӂ̗O
	 */
	public ProcessWaitActivityDAO getProcessWaitActivityDAO()
		throws Exception;

	/**
	 * SequencerDAOԂB
	 *
	 * @return SequencerDAO
	 * @throws Exception Cӂ̗O
	 */
	public SequencerDAO getSequencerDAO()
		throws Exception;

	/**
	 * SourceActivityDAOԂB
	 *
	 * @return SourceActivityDAO
	 * @throws Exception Cӂ̗O
	 */
	public SourceActivityDAO getSourceActivityDAO()
		throws Exception;

	/**
	 * TargetProcessDAOԂB
	 *
	 * @return TargetProcessDAO
	 * @throws Exception Cӂ̗O
	 */
	public TargetProcessDAO getTargetProcessDAO()
		throws Exception;

	/**
	 * VariableDAOԂB
	 *
	 * @return VariableDAO
	 * @throws Exception Cӂ̗O
	 */
	public VariableDAO getVariableDAO()
		throws Exception;

	/**
	 * VariableHistoryDAOԂB
	 *
	 * @return VariableHistoryDAO
	 * @throws Exception Cӂ̗O
	 */
	public VariableHistoryDAO getVariableHistoryDAO()
		throws Exception;

	/**
	 * WorkItemDAOԂB
	 *
	 * @return WorkItemDAO
	 * @throws Exception Cӂ̗O
	 */
	public WorkItemDAO getWorkItemDAO()
		throws Exception;
	
	/**
	 * OrganizationManagerDAOԂB
	 *
	 * @return OrganizationManagerDAO
	 * @throws Exception Cӂ̗O
	 */
	public OrganizationManagerDAO getOrganizationManagerDAO()
	    throws Exception;
	
	/**
	 * RoleManagerDAOԂB
	 *
	 * @return RoleManagerDAO
	 * @throws Exception Cӂ̗O
	 */
	public RoleManagerDAO getRoleManagerDAO()
	    throws Exception;
	
	/**
	 * UserManagerDAOԂB
	 *
	 * @return UserManagerDAO
	 * @throws Exception Cӂ̗O
	 */
	public UserManagerDAO getUserManagerDAO()
	    throws Exception;
}
