/* $Id: MySQLActivityHistoryDAO.java,v 1.9 2005/08/26 04:54:47 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityHistoryBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityHistoryDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * ActivityHistoryBeanf[^ƂMySQLpDAONXłB
 * <pre><tt>
 * ACTIVITYHISTe[u
 * +-------------+--------------+------+-----+---------------------+-------+
 * | Field       | Type         | Null | Key | Default             | Extra |
 * +-------------+--------------+------+-----+---------------------+-------+
 * | PROC_ID     | varchar(64)  |      | PRI |                     |       |
 * | ACT_ID      | varchar(64)  |      | PRI |                     |       |
 * | ACT_DEF_ID  | varchar(64)  |      |     |                     |       |
 * | ACTOR_ID    | varchar(64)  |      |     |                     |       |
 * | PREV_STATE  | int(1)       | YES  |     | NULL                |       |
 * | NEW_STATE   | int(1)       |      |     | 0                   |       |
 * | UPDATE_DATE | datetime     |      |     | 0000-00-00 00:00:00 |       |
 * | REASON      | varchar(128) | YES  |     | NULL                |       |
 * +-------------+--------------+------+-----+---------------------+-------+
 * </tt></pre>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.9 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLActivityHistoryDAO extends AbstractDAO implements ActivityHistoryDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/**@vZXID̃J */
	static public final String PROC_ID     = "PROC_ID";
	/**@ANeBreBID̃J */
	static public final String ACT_ID      = "ACT_ID";
	/**@ANeBreB`ID̃J */
	static public final String ACT_DEF_ID  = "ACT_DEF_ID";
	/**@ANeBreBID̃J */
	static public final String ACTOR_ID    = "ACTOR_ID";
	/**@ȌԂ̃J */
	static public final String PREV_STATE  = "PREV_STATE";
	/**@VԂ̃J */
	static public final String NEW_STATE   = "NEW_STATE";
	/**@XṼJ */
	static public final String UPDATE_DATE = "UPDATE_DATE";
	/**@XVR̃J */
	static public final String REASON      = "REASON";

	static private final String SQL_INSERT
	= "insert into ACTIVITYHIST ("
		+ PROC_ID + ", "
		+ ACT_ID + ", "
		+ ACT_DEF_ID + ", "
		+ ACTOR_ID + ", "
		+ PREV_STATE + ", "
		+ NEW_STATE + ", "
		+ UPDATE_DATE + ", "
		+ REASON + ") values (?,?,?,?,?,?,?,?)";

	/**
	 * vZXǗe[uɑ΂ANZXIuWFNg𐶐B
	 *
	 * @param conn RlNV
	 */
	MySQLActivityHistoryDAO(Connection conn)
	{
		super(conn);
	}
	
	/**
	 * ANeBreBύX}B
	 *
	 * @param bean ANeBreBύX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.ActivityHistoryDAO#insert(jp.co.argo21.nautica.workflow.dataaccess.ActivityHistoryBean)
	 */
	public void insert(ActivityHistoryBean bean)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_INSERT);
		try {
			st.setString(1, bean.getProcID());
			st.setString(2, bean.getActID());
			st.setString(3, bean.getActDefID());
			st.setString(4, bean.getActorID());
			st.setInt(5, bean.getPrevState());
			st.setInt(6, bean.getNewState());
			st.setTimestamp(7, bean.getUpdateDate());
			st.setString(8, bean.getReason());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// ANeBreBR[h̑}Ɏs܂B
				String errMsg = StringManager.get("E0012");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}
	
	/**
	 * ʃZbgANeBreBύX쐬B
	 *
	 * @param rs ʃZbg
	 * @return ANeBreBύX
	 * @throws SQLException CӂSQLO
	 */
	private ActivityHistoryBean createBean(ResultSet rs)
	throws SQLException
	{
		ActivityHistoryBean bean = new ActivityHistoryBean();

		bean.setProcID(rs.getString(PROC_ID));
		bean.setActID(rs.getString(ACT_ID));
		bean.setActDefID(rs.getString(ACT_DEF_ID));
		bean.setActorID(rs.getString(ACTOR_ID));
		bean.setPrevState(rs.getInt(PREV_STATE));
		bean.setNewState(rs.getInt(NEW_STATE));
		bean.setUpdateDate(rs.getTimestamp(UPDATE_DATE));
		bean.setReason(rs.getString(REASON));
		
		return bean;
	}
}
