/* $Id: MySQLAppExecutionDAO.java,v 1.11 2005/08/26 04:54:50 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionBean;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.ta.ApplicationState;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * AvP[Vse[uɑΉMySQLpDAONXłBB
 * 
 * <pre><tt>
 * APPEXECe[u
 * +------------+-------------+------+-----+---------+-------+
 * | Field      | Type        | Null | Key | Default | Extra |
 * +------------+-------------+------+-----+---------+-------+
 * | APP_NAME   | varchar(64) |      | PRI |         |       |
 * | TOOL_AGENT | varchar(64) |      | PRI |         |       |
 * | EXEC_ID    | bigint(19)  |      | PRI | 0       |       |
 * | START_DATE | datetime    | YES  |     | NULL    |       |
 * | STARTER_ID | varchar(64) | YES  |     | NULL    |       |
 * | END_DATE   | datetime    | YES  |     | NULL    |       |
 * | APP_STATE  | int(1)      | YES  |     | 2       |       |
 * +------------+-------------+------+-----+---------+-------+
 * </pre>
 * 
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.11 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLAppExecutionDAO extends AbstractDAO implements AppExecutionDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

    /** AvP[ṼJ */
	static public final String APP_NAME   = "APP_NAME";
	/** AvP[VNc[G[WFg̃NX̃J */
	static public final String TOOL_AGENT  = "TOOL_AGENT";
	/** sID̃J */
	static public final String EXEC_ID    = "EXEC_ID";
	/** JñJ */
	static public final String START_DATE = "START_DATE";
	/** s҂̃J */
	static public final String STARTER_ID = "STARTER_ID";
	/** ĨJ */
	static public final String END_DATE   = "END_DATE";
	/** sԂ̃J */
	static public final String APP_STATE  = "APP_STATE";

	static private final String SQL_SELECT_BY_PRIMARY_KEY
	= "select * from APPEXEC where APP_NAME = ? and TOOL_AGENT = ? and EXEC_ID = ?";

	static private final String SQL_SELECT_BY_EXEC_ID
	= "select * from APPEXEC where EXEC_ID = ? ";

	static private final String SQL_SELECT_BY_STARTER_ID
	= "select * from APPEXEC where STARTER_ID = ? ";

	static private final String SQL_INSERT
	= "insert into APPEXEC ("
		+ APP_NAME + ", "
		+ TOOL_AGENT + ", "
		+ EXEC_ID + ", "
		+ START_DATE + ", "
		+ STARTER_ID + ", "
		+ END_DATE + ", "
		+ APP_STATE + ") values (?, ?, ?, ?, ?, ?, ?)";

	static private final String SQL_UPDATE_STATE
	= "update APPEXEC set "
		+ APP_STATE + " = ? where "
		+ APP_NAME + " = ? and "
		+ TOOL_AGENT + " = ? and "
		+ EXEC_ID + " = ? and "
		+ APP_STATE + " = ?";

	static private final String SQL_UPDATE_STATE_END_DATE
	= "update APPEXEC set "
		+ APP_STATE + " = ?, " 
		+ END_DATE + " = ? where "
		+ APP_NAME + " = ? and "
		+ TOOL_AGENT + " = ? and "
		+ EXEC_ID + " = ? and "
		+ APP_STATE + " = ?";
	
	/**
	 * AvP[Vse[uɑ΂ANZXIuWFNg𐶐B
	 *
	 * @param conn RlNV
	 */
    MySQLAppExecutionDAO(Connection conn)
	{
		super(conn);
	}

    /**
     * L[ŁAAvP[Vse[uIuWFNg擾B
     * 
     * AvP[Vse[u̎L[łA
     * AvP[VAc[G[WFg̃NXAsIDŁA
     * AvP[Vse[uIuWFNg擾B
     *
     * @param appName		AvP[V
     * @param toolAgent		AvP[VNc[G[WFg̃NX
     * @param execID		c[G[WFgssID
     * @return		AvP[Vse[uIuWFNg
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
     * @see jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO#findByPrimaryKey(java.lang.String, java.lang.String, int)
     */
    public AppExecutionBean findByPrimaryKey(String appName, String toolAgent, int execID) 
    throws SQLException, DAOException 
    {
        AppExecutionBean bean = null;
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
		try {
		    st.setString(1, appName);
		    st.setString(2, toolAgent);
		    st.setInt(3, execID);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/

			ResultSet rs = st.executeQuery();
			
			if (rs.next()) {
				bean = createBean(rs);
			}
		} finally {
			st.close();
		}
		
        return bean;
    }

    /**
	 * sIDŁAAvP[Vse[uIuWFNg擾B
	 * 
	 * L[̈ꕔłAsIDŃAvP[Vse[uIuWFNg̃Xg
	 * 擾
	 *
	 * @param execID	sID
	 * @return		AvP[Vse[uIuWFNg̃Xg
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
     * @see jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO#findByExecID(int)
     */
	public List findByExecID(int execID)
	throws SQLException, DAOException 
	{
	    List list = new ArrayList();
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_EXEC_ID);
		try {
		    st.setInt(1, execID);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/

			ResultSet rs = st.executeQuery();
			
			while (rs.next()) {
				AppExecutionBean bean = createBean(rs);
				list.add(bean);
			}
		} finally {
			st.close();
		}
		return list;
	}
    
	/**
	 * JnIDŁAAvP[Vse[uIuWFNg擾B
	 * JnIDƂ́AΉƍIDłB
	 *
	 * @param starterID JnID
	 * @return		AvP[Vse[uIuWFNg̃Xg
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO#findByStarterID(java.lang.String)
	 */
	public List findByStarterID(String starterID)
	throws SQLException, DAOException
	{
	    List list = new ArrayList();
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_STARTER_ID);
		try {
		    st.setString(1, starterID);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/

		    ResultSet rs = st.executeQuery();
			
			while (rs.next()) {
				AppExecutionBean bean = createBean(rs);
				list.add(bean);
			}
		} finally {
			st.close();
		}
		return list;
	}
    
    /**
	 * AvP[Vse[uɃR[hǉB
	 * 
	 * @param bean		AvP[Vse[uIuWFNg
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
     * @see jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO#insert(jp.co.argo21.nautica.workflow.dataaccess.AppExecutionBean)
     */
    public void insert(AppExecutionBean bean) throws SQLException, DAOException {
		PreparedStatement st = getConnection().prepareStatement(SQL_INSERT);
		try {
			st.setString(1, bean.getAppName());
			st.setString(2, bean.getToolAgent());
			st.setInt(3, bean.getExecId());
			st.setTimestamp(4, bean.getStartDate());
			st.setString(5, bean.getStarterId());
			st.setTimestamp(6, bean.getEndDate());
			st.setInt(7, bean.getAppState().toInt());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// }G[
			    String errMsg = StringManager.get("E0005");
			    errMsg = errMsg 
			    	+ "APPNAME=" + bean.getAppName() + ", "
		        	+ "TOOL_AGENT=" + bean.getToolAgent() + ", "
		        	+ "EXEC_ID=" + bean.getExecId() + ", "
		        	+ "START_DATE=" + bean.getStartDate() + ", "
		        	+ "STARTER_ID=" + bean.getStarterId() + ", "
		        	+ "END_DATE=" + bean.getEndDate() + ", "
		        	+ "APP_STATE=" + bean.getAppState();
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
    }

    /**
	 * sԂXV
	 *
	 * @param appName		AvP[V
	 * @param toolAgent		c[G[WFg̃NX
	 * @param execID		sID
	 * @param oldState		s
	 * @param newState		Vs
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO#updateState(java.lang.String, java.lang.String, int, jp.co.argo21.nautica.workflow.ta.ApplicationState, jp.co.argo21.nautica.workflow.ta.ApplicationState)
	 */
	public void updateState(String appName, String toolAgent, int execID, 
	        ApplicationState oldState, ApplicationState newState)
            throws SQLException, DAOException {
		PreparedStatement st = getConnection().prepareStatement(SQL_UPDATE_STATE);
		try {
			st.setInt(1, newState.toInt());
			st.setString(2, appName);
			st.setString(3, toolAgent);
			st.setInt(4, execID);
			st.setInt(5, oldState.toInt());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// XVG[
			    String errMsg = StringManager.get("E0006");
			    errMsg = errMsg
			    	+ "APPNAME=" + appName + ", "
			    	+ "TOOL_AGENT=" + toolAgent + ", "
			    	+ "EXEC_ID=" + execID + ", "
			    	+ "OLD_STATE=" + oldState + ", "
			    	+ "NEW_STATE=" + newState;
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
    }
	
	/**
	 * sԂƏIXV
	 *
	 * @param appName		AvP[V
	 * @param toolAgent		c[G[WFg̃NX
	 * @param execID		sID
	 * @param oldState		s
	 * @param newState		Vs
	 * @param newDate		VI
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO#updateState(java.lang.String, java.lang.String, int, jp.co.argo21.nautica.workflow.ta.ApplicationState, jp.co.argo21.nautica.workflow.ta.ApplicationState, java.sql.Timestamp)
	 */
	public void updateState(String appName, String toolAgent, int execID, 
	        ApplicationState oldState, ApplicationState newState, Timestamp newDate)
	throws SQLException, DAOException {
	    PreparedStatement st = getConnection().prepareStatement(SQL_UPDATE_STATE_END_DATE);
		try {
			st.setInt(1, newState.toInt());
			st.setTimestamp(2, newDate);
			st.setString(3, appName);
			st.setString(4, toolAgent);
			st.setInt(5, execID);
			st.setInt(6, oldState.toInt());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// XVG[
			    String errMsg = StringManager.get("E0006");
			    errMsg = errMsg
			    	+ "APPNAME=" + appName + ", "
			    	+ "TOOL_AGENT=" + toolAgent + ", "
			    	+ "EXEC_ID=" + execID + ", "
			    	+ "OLD_STATE=" + oldState + ", "
			    	+ "NEW_STATE=" + newState + ", "
			    	+ "NEW_END_DATE=" + newDate;
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}

	/**
	 * ResultSet  AvP[Vse[uIuWFNg𐶐
	 *
	 * @param rs	ResultSet
	 * @return		AvP[Vse[uIuWFNg
	 * @throws SQLException CӂSQLO
	 */
	private AppExecutionBean createBean(ResultSet rs)
	throws SQLException
	{
	    AppExecutionBean bean = new AppExecutionBean();

	    bean.setAppName(rs.getString(APP_NAME));
	    bean.setToolAgent(rs.getString(TOOL_AGENT));
	    bean.setExecId(rs.getInt(EXEC_ID));
	    bean.setStartDate(rs.getTimestamp(START_DATE));
	    bean.setStarterId(rs.getString(STARTER_ID));
	    bean.setEndDate(rs.getTimestamp(END_DATE));
	    bean.setAppState(ApplicationState.toApplicationState(rs.getInt(APP_STATE)));
	    
		return bean;
	}

}
