/* $Id: MySQLApplicationDAO.java,v 1.7 2005/08/26 04:54:45 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.ApplicationBean;
import jp.co.argo21.nautica.workflow.dataaccess.ApplicationDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * ApplicationBeanf[^ƂMySQLpDAONXłB
 * <pre><tt>
 * APPLICATIONe[u
 * +----------+-------------+------+-----+---------+-------+
 * | Field    | Type        | Null | Key | Default | Extra |
 * +----------+-------------+------+-----+---------+-------+
 * | APP_NAME | varchar(64) |      | PRI |         |       |
 * | APP_TYPE | int(3)      |      | MUL | 0       |       |
 * +----------+-------------+------+-----+---------+-------+
 * </tt></pre>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLApplicationDAO extends AbstractDAO implements ApplicationDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/** AvP[ṼJ */
	static public final String APP_NAME = "APP_NAME";
	/** AvP[V^CṽJ */
	static public final String APP_TYPE = "APP_TYPE";

	static private final String SQL_SELECT_BY_PRIMARY_KEY
	= "select * from APPLICATION where APP_NAME = ? ";

	static private final String SQL_INSERT
	= "insert into APPLICATION ("
		+ APP_NAME + ", "
		+ APP_TYPE + ") values (?,?)";

	/**
	 * vZXǗe[uɑ΂ANZXIuWFNg𐶐B
	 *
	 * @param conn RlNV
	 */
	MySQLApplicationDAO(Connection conn)
	{
		super(conn);
	}
	
	/**
	 * L[ɂAApplicationBean擾B
	 *
	 * @param appName AvP[V
	 * @return ApplicationBean
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.ApplicationDAO#findByPrimaryKey(java.lang.String)
	 */
	public ApplicationBean findByPrimaryKey(String appName)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
		try {
			st.setString(1, appName);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			ApplicationBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}
	
	/**
	 * ApplicationBean}B
	 *
	 * @param bean ApplicationBean
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.ApplicationDAO#insert(jp.co.argo21.nautica.workflow.dataaccess.ApplicationBean)
	 */
	public void insert(ApplicationBean bean)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_INSERT);
		try {
			st.setString(1, bean.getAppName());
			st.setInt(2, bean.getAppType());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
			    // AvP[VR[h̑}Ɏs܂B
				String errMsg = StringManager.get("E0049");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}
	
	/**
	 * ʃZbgApplicationBean𐶐B
	 *
	 * @param rs ʃZbg
	 * @return ApplicationBean
	 * @throws SQLException CӂSQLO
	 */
	private ApplicationBean createBean(ResultSet rs)
	throws SQLException
	{
		ApplicationBean bean = new ApplicationBean();

		bean.setAppName(rs.getString(APP_NAME));
		bean.setAppType(rs.getInt(APP_TYPE));
		
		return bean;
	}
}
