/* $Id: MySQLConcurrencyBlockDAO.java,v 1.11 2005/08/26 04:54:40 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockBean;
import jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * ConcurrencyBlockBeanf[^ƂMySQLpDAONXłB
 * <pre><tt>
 * CONCURBLOCKe[u
 * +----------------+-------------+------+-----+---------+-------+
 * | Field          | Type        | Null | Key | Default | Extra |
 * +----------------+-------------+------+-----+---------+-------+
 * | BLOCK_ID       | varchar(64) |      |     |         |       |
 * | UPPER_BLOCK_ID | varchar(64) | YES  |     | NULL    |       |
 * | PROC_ID        | varchar(64) |      | MUL |         |       |
 * | ACT_ID         | varchar(64) |      |     |         |       |
 * +----------------+-------------+------+-----+---------+-------+
 * </tt></pre>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.11 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLConcurrencyBlockDAO extends AbstractDAO implements ConcurrencyBlockDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/** ubNID̃J */
	static public final String BLOCK_ID       = "BLOCK_ID";
	/** ʃubNID̃J */
	static public final String UPPER_BLOCK_ID = "UPPER_BLOCK_ID";
	/** vZXID̃J */
	static public final String PROC_ID        = "PROC_ID";
	/** ANeBreBID̃J */
	static public final String ACT_ID         = "ACT_ID";

	static private final String SQL_SELECT_BY_PRIMARY_KEY
	= "select * from CONCURBLOCK where PROC_ID = ? AND BLOCK_ID = ? ";

	//݂TuubNT
	static private final String SQL_SELECT_COUNT_EXIST_BY_BLOCK_ID
	= "select COUNT(*) from CONCURBLOCK where PROC_ID = ? AND UPPER_BLOCK_ID = ? ";

	//݂TuubNT
	static private final String SQL_SELECT_COUNT_EXIST_BY_PROC_ID
	= "select COUNT(*) from CONCURBLOCK where PROC_ID = ? ";

	static private final String SQL_INSERT
	= "insert into CONCURBLOCK ("
		+ BLOCK_ID + ", "
		+ UPPER_BLOCK_ID + ", "
		+ PROC_ID + ", "
		+ ACT_ID + ") values (?,?,?,?)";

	private static final String SQL_DELETE
	= "delete from CONCURBLOCK where PROC_ID = ? AND BLOCK_ID = ? ";

	/**
	 * vZXǗe[uɑ΂ANZXIuWFNg𐶐B
	 *
	 * @param conn RlNV
	 */
	MySQLConcurrencyBlockDAO(Connection conn)
	{
		super(conn);
	}

	/**
	 * L[ɂAsubN擾B
	 *
	 * @param pid vZXID
	 * @param bid ubNID
	 * @return subN
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockDAO#findByPrimaryKey(java.lang.String, java.lang.String)
	 */
	public ConcurrencyBlockBean findByPrimaryKey(String pid, String bid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
		try {
			st.setString(1, pid);
			st.setString(2, bid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			ConcurrencyBlockBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}

	/**
	 * ubÑTuubN݂̑擾B
	 *
	 * @param pid vZXID
	 * @param bid ubNID
	 * @return ݂TuubŇ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockDAO#findSubblockExistenceByBlockID(java.lang.String, java.lang.String)
	 */
	public int findSubblockExistenceByBlockID(String pid, String bid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_COUNT_EXIST_BY_BLOCK_ID);
		try {
			st.setString(1, pid);
			st.setString(2, bid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			int count = 0;
			if (rs.next()) {
				count = rs.getInt(1);
			}
			return count;
		} finally {
			st.close();
		}
	}
	
	/**
	 * vZX̃TuubN݂̑擾B
	 *
	 * @param pid vZXID
	 * @return ݂TuubŇ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockDAO#findSubblockExistenceByProcessID(java.lang.String)
	 */
	public int findSubblockExistenceByProcessID(String pid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_COUNT_EXIST_BY_PROC_ID);
		try {
			st.setString(1, pid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			int count = 0;
			if (rs.next()) {
				count = rs.getInt(1);
			}
			return count;
		} finally {
			st.close();
		}
	}
	
	/**
	 * subN}B
	 *
	 * @param bean subN
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockDAO#insert(jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockBean)
	 */
	public void insert(ConcurrencyBlockBean bean)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_INSERT);
		try {
			st.setString(1, bean.getBlockID());
			st.setString(2, bean.getUpperBlockID());
			st.setString(3, bean.getProcID());
			st.setString(4, bean.getActID());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// subNR[h̑}Ɏs܂B
				String errMsg = StringManager.get("E0015");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}

	/**
	 * subN폜B
	 *
	 * @param pid vZXID
	 * @param bid ubNID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockDAO#delete(java.lang.String, java.lang.String)
	 */
	public void delete(String pid, String bid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_DELETE);
		try {
			st.setString(1, pid);
			st.setString(2, bid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// subNR[h̍폜Ɏs܂B
				String errMsg = StringManager.get("E0014");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}
	
	/**
	 * ʃZbgsubN쐬B
	 *
	 * @param rs ʃZbg
	 * @return subN
	 * @throws SQLException CӂSQLO
	 */
	private ConcurrencyBlockBean createBean(ResultSet rs)
	throws SQLException
	{
		ConcurrencyBlockBean bean = new ConcurrencyBlockBean();

		bean.setBlockID(rs.getString(BLOCK_ID));
		bean.setUpperBlockID(rs.getString(UPPER_BLOCK_ID));
		bean.setProcID(rs.getString(PROC_ID));
		bean.setActID(rs.getString(ACT_ID));
		
		return bean;
	}
}
