/* $Id: MySQLDAOFactory.java,v 1.10 2005/08/26 04:54:41 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityHistoryDAO;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ApplicationDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ApplicationTypeDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.OrganizationManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessHistoryDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.RoleManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.SequencerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.SourceActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.UserManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.VariableHistoryDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;

/**
 * MySQLp̃[Nt[֘Ae[uɑ΂eDAO𐶐t@Ng[NXB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.10 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLDAOFactory implements WorkflowDAOFactory
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/**
	 * t@Ng[𐶐B
	 */
	public MySQLDAOFactory()
	{
	}

	/**
	 * ActivityDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ActivityDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getActivityDAO(java.sql.Connection)
	 */
	public ActivityDAO getActivityDAO(Connection conn) throws Exception
	{
		return new MySQLActivityDAO(conn);
	}

	/**
	 * ActivityHistoryDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ActivityHistoryDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getActivityHistoryDAO(java.sql.Connection)
	 */
	public ActivityHistoryDAO getActivityHistoryDAO(Connection conn)
			throws Exception
	{
		return new MySQLActivityHistoryDAO(conn);
	}

	/**
	 * AppExecutionDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return AppExecutionDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getAppExecutionDAO(java.sql.Connection)
	 */
	public AppExecutionDAO getAppExecutionDAO(Connection conn) throws Exception
	{
		return new MySQLAppExecutionDAO(conn);
	}

	/**
	 * ApplicationDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ApplicationDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getApplicationDAO(java.sql.Connection)
	 */
	public ApplicationDAO getApplicationDAO(Connection conn) throws Exception
	{
		return new MySQLApplicationDAO(conn);
	}

	/**
	 * ApplicationTypeDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ApplicationTypeDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getApplicationTypeDAO(java.sql.Connection)
	 */
	public ApplicationTypeDAO getApplicationTypeDAO(Connection conn)
			throws Exception
	{
		return new MySQLApplicationTypeDAO(conn);
	}

	/**
	 * ConcurrencyBlockDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ConcurrencyBlockDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getConcurrencyBlockDAO(java.sql.Connection)
	 */
	public ConcurrencyBlockDAO getConcurrencyBlockDAO(Connection conn)
			throws Exception
	{
		return new MySQLConcurrencyBlockDAO(conn);
	}

	/**
	 * DefinitionDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return DefinitionDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getDefinitionDAO(java.sql.Connection)
	 */
	public DefinitionDAO getDefinitionDAO(Connection conn) throws Exception
	{
		return new MySQLDefinitionDAO(conn);
	}

	/**
	 * ProcessDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ProcessDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getProcessDAO(java.sql.Connection)
	 */
	public ProcessDAO getProcessDAO(Connection conn) throws Exception
	{
		return new MySQLProcessDAO(conn);
	}

	/**
	 * ProcessHistoryDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ProcessHistoryDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getProcessHistoryDAO(java.sql.Connection)
	 */
	public ProcessHistoryDAO getProcessHistoryDAO(Connection conn)
			throws Exception
	{
		return new MySQLProcessHistoryDAO(conn);
	}

	/**
	 * ProcessWaitActivityDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return ProcessWaitActivityDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getProcessWaitActivityDAO(java.sql.Connection)
	 */
	public ProcessWaitActivityDAO getProcessWaitActivityDAO(Connection conn)
			throws Exception
	{
		return new MySQLProcessWaitActivityDAO(conn);
	}

	/**
	 * SequencerDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return SequencerDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getSequencerDAO(java.sql.Connection)
	 */
	public SequencerDAO getSequencerDAO(Connection conn) throws Exception
	{
		return new MySQLSequencerDAO(conn);
	}

	/**
	 * SourceActivityDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return SourceActivityDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getSourceActivityDAO(java.sql.Connection)
	 */
	public SourceActivityDAO getSourceActivityDAO(Connection conn)
			throws Exception
	{
		return new MySQLSourceActivityDAO(conn);
	}

	/**
	 * TargetProcessDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return TargetProcessDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getTargetProcessDAO(java.sql.Connection)
	 */
	public TargetProcessDAO getTargetProcessDAO(Connection conn)
			throws Exception
	{
		return new MySQLTargetProcessDAO(conn);
	}

	/**
	 * VariableDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return VariableDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getVariableDAO(java.sql.Connection)
	 */
	public VariableDAO getVariableDAO(Connection conn) throws Exception
	{
		return new MySQLVariableDAO(conn);
	}

	/**
	 * VariableHistoryDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return VariableHistoryDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getVariableHistoryDAO(java.sql.Connection)
	 */
	public VariableHistoryDAO getVariableHistoryDAO(Connection conn)
			throws Exception
	{
		return new MySQLVariableHistoryDAO(conn);
	}

	/**
	 * WorkItemDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return WorkItemDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getWorkItemDAO(java.sql.Connection)
	 */
	public WorkItemDAO getWorkItemDAO(Connection conn) throws Exception
	{
		return new MySQLWorkItemDAO(conn);
	}
	
	/**
	 * OrganizationManagerDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return OrganizationManagerDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getOrganizationManagerDAO(java.sql.Connection)
	 */
	public OrganizationManagerDAO getOrganizationManagerDAO(Connection conn) 
	        throws Exception
	{
	    return new MySQLOrganizationManagerDAO(conn);
	}

	/**
	 * RoleManagerDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return RoleManagerDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getRoleManagerDAO(java.sql.Connection)
	 */
	public RoleManagerDAO getRoleManagerDAO(Connection conn) throws Exception
	{
	    return new MySQLRoleManagerDAO(conn);
	}

	/**
	 * UserManagerDAOԂB
	 *
	 * @param conn JDBCڑ
	 * @return UserManagerDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getUserManagerDAO(java.sql.Connection)
	 */
	public UserManagerDAO getUserManagerDAO(Connection conn) throws Exception
	{
	    return new MySQLUserManagerDAO(conn);
	}
	
	/**
	 * ActivityDAOԂB
	 *
	 * @return ActivityDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getActivityDAO(java.sql.Connection)
	 */
	public ActivityDAO getActivityDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLActivityDAO(conn);
	}

	/**
	 * ActivityHistoryDAOԂB
	 *
	 * @return ActivityHistoryDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getActivityHistoryDAO()
	 */
	public ActivityHistoryDAO getActivityHistoryDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLActivityHistoryDAO(conn);
	}

	/**
	 * AppExecutionDAOԂB
	 *
	 * @return AppExecutionDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getAppExecutionDAO()
	 */
	public AppExecutionDAO getAppExecutionDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLAppExecutionDAO(conn);
	}

	/**
	 * ApplicationDAOԂB
	 *
	 * @return ApplicationDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getApplicationDAO()
	 */
	public ApplicationDAO getApplicationDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLApplicationDAO(conn);
	}

	/**
	 * ApplicationTypeDAOԂB
	 *
	 * @return ApplicationTypeDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getApplicationTypeDAO()
	 */
	public ApplicationTypeDAO getApplicationTypeDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLApplicationTypeDAO(conn);
	}

	/**
	 * ConcurrencyBlockDAOԂB
	 *
	 * @return ConcurrencyBlockDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getConcurrencyBlockDAO()
	 */
	public ConcurrencyBlockDAO getConcurrencyBlockDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLConcurrencyBlockDAO(conn);
	}

	/**
	 * DefinitionDAOԂB
	 *
	 * @return DefinitionDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getDefinitionDAO()
	 */
	public DefinitionDAO getDefinitionDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLDefinitionDAO(conn);
	}

	/**
	 * ProcessDAOԂB
	 *
	 * @return ProcessDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getProcessDAO()
	 */
	public ProcessDAO getProcessDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLProcessDAO(conn);
	}

	/**
	 * ProcessHistoryDAOԂB
	 *
	 * @return ProcessHistoryDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getProcessHistoryDAO()
	 */
	public ProcessHistoryDAO getProcessHistoryDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLProcessHistoryDAO(conn);
	}

	/**
	 * ProcessWaitActivityDAOԂB
	 *
	 * @return ProcessWaitActivityDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getProcessWaitActivityDAO()
	 */
	public ProcessWaitActivityDAO getProcessWaitActivityDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLProcessWaitActivityDAO(conn);
	}

	/**
	 * SequencerDAOԂB
	 *
	 * @return SequencerDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getSequencerDAO()
	 */
	public SequencerDAO getSequencerDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLSequencerDAO(conn);
	}

	/**
	 * SourceActivityDAOԂB
	 *
	 * @return SourceActivityDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getSourceActivityDAO()
	 */
	public SourceActivityDAO getSourceActivityDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLSourceActivityDAO(conn);
	}

	/**
	 * TargetProcessDAOԂB
	 *
	 * @return TargetProcessDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getTargetProcessDAO()
	 */
	public TargetProcessDAO getTargetProcessDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLTargetProcessDAO(conn);
	}

	/**
	 * VariableDAOԂB
	 *
	 * @return VariableDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getVariableDAO()
	 */
	public VariableDAO getVariableDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLVariableDAO(conn);
	}

	/**
	 * VariableHistoryDAOԂB
	 *
	 * @return VariableHistoryDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getVariableHistoryDAO()
	 */
	public VariableHistoryDAO getVariableHistoryDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLVariableHistoryDAO(conn);
	}

	/**
	 * WorkItemDAOԂB
	 *
	 * @return WorkItemDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getWorkItemDAO()
	 */
	public WorkItemDAO getWorkItemDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new MySQLWorkItemDAO(conn);
	}
	
	/**
	 * OrganizationManagerDAOԂB
	 *
	 * @return OrganizationManagerDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getOrganizationManagerDAO()
	 */
	public OrganizationManagerDAO getOrganizationManagerDAO() 
	        throws Exception
	{
	    Connection conn = DataAccessManager.getConnection();
	    return new MySQLOrganizationManagerDAO(conn);
	}

	/**
	 * RoleManagerDAOԂB
	 *
	 * @return RoleManagerDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getRoleManagerDAO()
	 */
	public RoleManagerDAO getRoleManagerDAO() throws Exception
	{
	    Connection conn = DataAccessManager.getConnection();
	    return new MySQLRoleManagerDAO(conn);
	}
	
	/**
	 * UserManagerDAOԂB
	 *
	 * @return UserManagerDAO
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getUserManagerDAO()
	 */
	public UserManagerDAO getUserManagerDAO() throws Exception
	{
	    Connection conn = DataAccessManager.getConnection();
	    return new MySQLUserManagerDAO(conn);
	}
}
