/* $Id: MySQLDefinitionDAO.java,v 1.17 2005/08/26 04:54:50 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionBean;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.filter.FilterConverter;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;

/**
 * DefinitionBeanf[^ƂMySQLpDAONXłB
 * <pre><tt>
 * DEFINITIONe[u
 * +---------------+--------------+------+-----+---------------------+-------+
 * | Field         | Type         | Null | Key | Default             | Extra |
 * +---------------+--------------+------+-----+---------------------+-------+
 * | PROC_DEF_ID   | varchar(64)  |      | PRI |                     |       |
 * | PATH          | varchar(128) |      |     |                     |       |
 * | INTERNAL_PDID | varchar(64)  |      |     |                     |       |
 * | REGISTER_DATE | datetime     |      |     | 0000-00-00 00:00:00 |       |
 * | DEF_STATE     | int(1)       |      |     | 0                   |       |
 * +---------------+--------------+------+-----+---------------------+-------+
 * </tt></pre>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.17 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLDefinitionDAO extends AbstractDAO
implements DefinitionDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/** vZX`ID̃J */
	static public final String PROC_DEF_ID   = "PROC_DEF_ID";
	/** `t@C̃pX̃J */
	static public final String PATH          = "PATH";
	/** vZX`ID̃J */
	static public final String INTERNAL_PDID = "INTERNAL_PDID";
	/** o^̃J */
	static public final String REGISTER_DATE = "REGISTER_DATE";
	/** `Ԃ̃J */
	static public final String DEF_STATE     = "DEF_STATE";

	static private final String SQL_SELECT_BY_PRIMARY_KEY
	= "select * from DEFINITION where PROC_DEF_ID = ? ";

	static private final String SQL_SELECT_BY_PATH_AND_ID
	= "select * from DEFINITION where PATH = ? and INTERNAL_PDID = ? ";

	static private final String SQL_SELECT
	= "select * from DEFINITION ";

	static private final String SQL_INSERT
	= "insert into DEFINITION ("
		+ PROC_DEF_ID + ", "
		+ PATH + ", "
		+ INTERNAL_PDID + ", "
		+ REGISTER_DATE + ", "
		+ DEF_STATE + ") values (?,?,?,?,?)";

	static private final String SQL_UPDATE_STATE
	= "update DEFINITION set "
		+ DEF_STATE + " = ? where "
		+ PROC_DEF_ID + " = ? AND "+ DEF_STATE + " = ? ";

	/**
	 * `Ǘe[uɑ΂ANZXIuWFNg𐶐B
	 *
	 * @param conn RlNV
	 */
	MySQLDefinitionDAO(Connection conn)
	{
		super(conn);
	}
	
	/**
	 * L[ɂA`擾B
	 *
	 * @param pdid `ID
	 * @return `
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO#findByPrimaryKey(java.lang.String)
	 */
	public DefinitionBean findByPrimaryKey(String pdid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
		try {
			st.setString(1, pdid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			DefinitionBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}

    /**
	 * pXƓvZX`IDŒ`擾B
	 *
	 * @param path `t@Cւ̑΃pX
     * @param ipdid vZX`ID
	 * @return `
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
     * @see jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO#findByPathAndID(java.lang.String, java.lang.String)
     */
	public DefinitionBean findByPathAndID(String path, String ipdid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PATH_AND_ID);
		try {
			st.setString(1, path);
			st.setString(2, ipdid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			DefinitionBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}
	
	/**
	 * tB^[ɂ肳ꂽ`擾B
	 *
	 * @param filter tB^[
	 * @return `
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @throws InvalidFilterException ȃtB^[w肳ꂽꍇ
	 * @see jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO#findByFilter(jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public List findByFilter(Filter filter)
	throws SQLException, DAOException, InvalidFilterException
	{
		FilterConverter converter = new DefinitionFilterConverter();
		String where = converter.convertToSQL(filter);
		
		if (where.equals("") == false) {
			where = " where " + where;
		}
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT + where);

		/************** DEBUG **************/
		eLog.debug(st.toString());
		/***********************************/

		try {
			ResultSet rs = st.executeQuery();
			
			List list = new ArrayList();
			while (rs.next()) {
				DefinitionBean bean = createBean(rs);
				list.add(bean);
			}
			return list;
		} finally {
			st.close();
		}
	}
	
	/**
	 * `}B
	 *
	 * @param bean `
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO#insert(jp.co.argo21.nautica.workflow.dataaccess.DefinitionBean)
	 */
	public void insert(DefinitionBean bean)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_INSERT);
		try {
			st.setString(1, bean.getProcessDefinitionID());
			st.setString(2, bean.getPath());
			st.setString(3, bean.getInternalPDID());
			st.setTimestamp(4, bean.getRegisterDate());
			st.setInt(5, bean.getState());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// `񃌃R[h̑}Ɏs܂B
				String errMsg = StringManager.get("E0016");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}
	
	/**
	 * `̏ԂXVB
	 *
	 * @param pdid `ID
	 * @param oldState Ȍ
	 * @param newState ̏
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO#updateState(java.lang.String, int, int)
	 */
	public void updateState(String pdid, int oldState, int newState)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_UPDATE_STATE);
		try {
			st.setInt(1, newState);
			st.setString(2, pdid);
			st.setInt(3, oldState);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// `񃌃R[h̍XVɎs܂B
				String errMsg = StringManager.get("E0017");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}
	
	/**
	 * ʃZbg`쐬B
	 *
	 * @param rs ʃZbg
	 * @return `
	 * @throws SQLException CӂSQLO
	 */
	private DefinitionBean createBean(ResultSet rs)
	throws SQLException
	{
		DefinitionBean bean = new DefinitionBean();

		bean.setProcessDefinitionID(rs.getString(PROC_DEF_ID));
		bean.setPath(rs.getString(PATH));
		bean.setInternalPDID(rs.getString(INTERNAL_PDID));
		bean.setRegisterDate(rs.getTimestamp(REGISTER_DATE));
		bean.setState(rs.getInt(DEF_STATE));
		
		return bean;
	}
}
