/* $Id: MySQLOrganizationManagerDAO.java,v 1.6 2005/08/26 04:54:49 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.OrganizationBean;
import jp.co.argo21.nautica.workflow.dataaccess.OrganizationManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.UserBean;
import jp.co.argo21.nautica.workflow.engine.LogManager;

/**
 * OrganizationBeanf[^ƂMySQLpDAONXłB
 * <pre><tt>
 * ORGANIZATIONe[u
 * +----------------+--------------+------+-----+---------+-------+
 * | Field          | Type         | Null | Key | Default | Extra |
 * +----------------+--------------+------+-----+---------+-------+
 * | ORG_ID         | varchar(64)  |      | PRI |         |       |
 * | ORG_NAME       | varchar(128) |      |     |         |       |
 * | RESPONSIBLE_ID | varchar(64)  | YES  | MUL | NULL    |       |
 * | HIGHER_ORG_ID  | varchar(64)  | YES  | MUL | NULL    |       |
 * +----------------+--------------+------+-----+---------+-------+
 * </tt>
 * <tt>
 * ORGUSERMAPe[u
 * +---------+-------------+------+-----+---------+-------+
 * | Field   | Type        | Null | Key | Default | Extra |
 * +---------+-------------+------+-----+---------+-------+
 * | ORG_ID  | varchar(64) |      | PRI |         |       |
 * | USER_ID | varchar(64) |      | PRI |         |       |
 * +---------+-------------+------+-----+---------+-------+
 * </tt></pre>
 * ́AJL[lƂĂB
 * J̑啶Ɋւ炸ÃL[l͑啶Őݒ肳B
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLOrganizationManagerDAO extends AbstractDAO 
implements OrganizationManagerDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();
	
	/** gDID̃J */
	private static final String ORG_ID = "ORG_ID";
	/** gD̃J */
	private static final String ORG_NAME = "ORG_NAME";
    
    private static final String SQL_SELECT_BY_ORG_ID
        = "select * from ORGANIZATION where ORG_ID = ?";
    
    private static final String SQL_SELECT_USERS_BY_ORG_ID
        = "select USER.* from USER, ORGUSERMAP" +
          " where ORGUSERMAP.ORG_ID = ? and USER.USER_ID = ORGUSERMAP.USER_ID;";
    
    private static final String SQL_SELECT_BY_USER_ID
        = "select ORGANIZATION.* from ORGANIZATION, ORGUSERMAP" +
          " where ORGUSERMAP.USER_ID = ? and ORGANIZATION.ORG_ID = ORGUSERMAP.ORG_ID;";
    
    private static final String SQL_SELECT_HIGHER_BY_ORG_ID
        = "SELECT ORG_HIGH.* FROM ORGANIZATION ORG_HIGH, ORGANIZATION ORG_LOW" + 
          " WHERE ORG_HIGH.ORG_ID = ORG_LOW.HIGHER_ORG_ID" + 
          " AND ORG_LOW.ORG_ID = ?";
    
    /**
     * gD֘Ae[uɑ΂ANZXIuWFNg𐶐B
     * 
     * @param conn RlNV
     */
    MySQLOrganizationManagerDAO(Connection conn) {
        super(conn);
    }

    /**
     * w肳ꂽgDID̑gDԂB
     * YgD񂪑݂Ȃꍇ null ԂB
     * 
     * @param  oid gDID
     * @return w肳ꂽgDID̏OrganizationBean
	 * @throws SQLException CӂSQLO
     * @see jp.co.argo21.nautica.workflow.dataaccess.OrganizationManagerDAO#findByOrganizationID(java.lang.String)
     */
    public OrganizationBean findByOrganizationID(String oid) 
    throws SQLException {
        
        PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_ORG_ID);
		try {
			st.setString(1, oid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/

			ResultSet rs = st.executeQuery();
			
			OrganizationBean bean = null;
			if (rs.next()) {
			    bean = createBean(rs);
			}
			
			return bean;
			
		} finally {
			st.close();
		}
    }

    /**
     * w肳ꂽgD̃[U̔zԂB
     * Y郆[U񂪑݂Ȃꍇ͋̔zԂB
     * 
     * @param  oid gDID
     * @return w肳ꂽgDɏ郆[UUserBean̔z
	 * @throws SQLException CӂSQLO
     * @see jp.co.argo21.nautica.workflow.dataaccess.OrganizationManagerDAO#findUsersByOrganizationID(java.lang.String)
     */
    public UserBean[] findUsersByOrganizationID(String oid)
    throws SQLException {
        
        PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_USERS_BY_ORG_ID);
		try {
			st.setString(1, oid);			

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/

			ResultSet rs = st.executeQuery();
						
			List beanList = new ArrayList();
			while (rs.next()) {
				beanList.add(MySQLUserManagerDAO.createBean(rs));
			}
			
			return (UserBean[]) beanList.toArray(new UserBean[beanList.size()]);
			
		} finally {
			st.close();
		}
    }

    /**
     * w肳ꂽ[ȔgD̔zԂB
     * YgD񂪑݂Ȃꍇ͋̔zԂB
     * 
     * @param  uid [UID
     * @return w肳ꂽ[UgDOrganizationBean̔z
	 * @throws SQLException CӂSQLO
     * @see jp.co.argo21.nautica.workflow.dataaccess.OrganizationManagerDAO#findByUserID(java.lang.String)
     */
    public OrganizationBean[] findByUserID(String uid) 
    throws SQLException {
        
        PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_USER_ID);
		try {
			st.setString(1, uid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/

			ResultSet rs = st.executeQuery();
			
			List beanList = new ArrayList();
			while (rs.next()) {
				beanList.add(createBean(rs));
			}	
			
			return (OrganizationBean[]) beanList.toArray(new OrganizationBean[beanList.size()]);
			
		} finally {
			st.close();
		}
    }

    /**
     * w肳ꂽgD̏ʑgDԂB
	 * YʑgD񂪑݂Ȃꍇ null ԂB
     * 
     * @param oid gDID
     * @return OrganizationBean
	 * @throws SQLException CӂSQLO
     * @see jp.co.argo21.nautica.workflow.dataaccess.OrganizationManagerDAO#findHigherByOrganizationID(java.lang.String)
     */
    public OrganizationBean findHigherByOrganizationID(String oid)
    throws SQLException {

        PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_HIGHER_BY_ORG_ID);
		try {
			st.setString(1, oid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/

			ResultSet rs = st.executeQuery();
			
			OrganizationBean bean = null;
			if (rs.next()) {
			    bean = createBean(rs);
			}
			
			return bean;
						
		} finally {
			st.close();
		}
    }
    
    /**
     * ResultSet̏񂩂OrganizationBean쐬B
     * 
     * @param  rs ResultSet
     * @return ResultSet擾OrganizationBean
	 * @throws SQLException CӂSQLO
     */
    static OrganizationBean createBean(ResultSet rs) throws SQLException {
        
        /* J擾 */
        List columnNames = new ArrayList();
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); i++) {
            columnNames.add(rs.getMetaData().getColumnName(i));
        }

        OrganizationBean bean = new OrganizationBean();
        for (int i = 0; i < columnNames.size(); i++) {
            String columnName = ((String) columnNames.get(i)).toUpperCase();
            String attribute = (String) rs.getObject(columnName);

            /* gDIDݒ */
            if (columnName.equals(ORG_ID)) {
                bean.setID(attribute);
            }
            
            /* gDݒ */
            if (columnName.equals(ORG_NAME)) {
                bean.setName(attribute);                
            }

            /* gDIDAgDȊȌgDɐݒ */
            if (!columnName.equals(ORG_ID)
                    && !columnName.equals(ORG_NAME)) {
                bean.setAttribute(columnName, attribute);
            }
        }
        return bean;
    }
}