/* $Id: MySQLProcessWaitActivityDAO.java,v 1.13 2005/08/26 04:54:38 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * ProcessWaitActivityBeanf[^ƂMySQLpDAONXłB
 * <pre><tt>
 * WAITPROCACTe[u
 * +------------+-------------+------+-----+---------+-------+
 * | Field      | Type        | Null | Key | Default | Extra |
 * +------------+-------------+------+-----+---------+-------+
 * | PROC_ID    | varchar(64) |      | MUL |         |       |
 * | ACT_ID     | varchar(64) |      |     |         |       |
 * | SUBPROC_ID | varchar(64) |      |     |         |       |
 * +------------+-------------+------+-----+---------+-------+
 * </tt></pre>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.13 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLProcessWaitActivityDAO extends AbstractDAO implements ProcessWaitActivityDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/** vZXID̃J */
	static public final String PROC_ID    = "PROC_ID";
	/** ANeBreBID̃J */
	static public final String ACT_ID     = "ACT_ID";
	/** TuvZXID̃J */
	static public final String SUBPROC_ID = "SUBPROC_ID";

	static private final String SQL_SELECT_BY_SUBPROC_ID
	= "select * from WAITPROCACT where SUBPROC_ID = ? ";

	static private final String SQL_SELECT_BY_PROCID_AND_ACTID
	= "select * from WAITPROCACT where PROC_ID = ? AND ACT_ID = ? ";

	static private final String SQL_INSERT
	= "insert into WAITPROCACT ("
		+ PROC_ID + ", "
		+ ACT_ID + ", "
		+ SUBPROC_ID + ") values (?,?,?)";

	static private final String SQL_DELETE
	= "delete from WAITPROCACT where SUBPROC_ID = ? ";

	/**
	 * vZXǗe[uɑ΂ANZXIuWFNg𐶐B
	 *
	 * @param conn RlNV
	 */
	MySQLProcessWaitActivityDAO(Connection conn)
	{
		super(conn);
	}

	/**
	 * IDɑΉTuvZXI҂ANeBreB擾B
	 *
	 * @param spid TuvZXID
	 * @return TuvZXI҂ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityDAO#findBySubprocessID(java.lang.String)
	 */
	public ProcessWaitActivityBean findBySubprocessID(String spid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_SUBPROC_ID);
		try {
			st.setString(1, spid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			ProcessWaitActivityBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}

	/**
	 * vZXIdƃANeBreBIDŃTuvZXI҂ANeBreB擾B
	 *
	 * @param pid vZXID
	 * @param aid ANeBreBID
	 * @return TuvZXI҂ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityDAO#findByProcIDANDActID(java.lang.String, java.lang.String)
	 */
	public ProcessWaitActivityBean findByProcIDANDActID(String pid, String aid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PROCID_AND_ACTID);
		try {
			st.setString(1, pid);
			st.setString(2, aid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			ProcessWaitActivityBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}
	
	/**
	 * TuvZXI҂ANeBreB}B
	 *
	 * @param bean TuvZXI҂ANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityDAO#insert(jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityBean)
	 */
	public void insert(ProcessWaitActivityBean bean)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_INSERT);
		try {
			st.setString(1, bean.getProcID());
			st.setString(2, bean.getActID());
			st.setString(3, bean.getSubprocID());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// TuvZXI҂ANeBreB̑}Ɏs܂B
				String errMsg = StringManager.get("E0024");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}
	
	/**
	 * TuvZXI҂ANeBreB폜B
	 *
	 * @param spid TuvZXID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityDAO#delete(java.lang.String)
	 */
	public void delete(String spid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_DELETE);
		try {
			st.setString(1, spid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// TuvZXI҂ANeBreB̍폜Ɏs܂B
				String errMsg = StringManager.get("E0023");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}
	
	/**
	 * ʃZbgvZXI҂ANeBreB쐬B
	 *
	 * @param rs ʃZbg
	 * @return vZXI҂ANeBreB
	 * @throws SQLException CӂSQLO
	 */
	private ProcessWaitActivityBean createBean(ResultSet rs)
	throws SQLException
	{
		ProcessWaitActivityBean bean = new ProcessWaitActivityBean();

		bean.setProcID(rs.getString(PROC_ID));
		bean.setActID(rs.getString(ACT_ID));
		bean.setSubprocID(rs.getString(SUBPROC_ID));
		
		return bean;
	}
}
