/* $Id: MySQLSequencerDAO.java,v 1.8 2005/08/26 04:54:46 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.SequencerDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;

/**
 * j[NID𐶐邽߂̃V[PT񋟂NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLSequencerDAO extends AbstractDAO implements SequencerDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/** V[PXԍ̃J */
	static public final String SEQ  = "SEQ";
	/** V[PX̃J */
	static public final String NAME = "NAME";

	/** VV[PTǉ邽߂SQL */
	private static final String SQL_INSERT_SEQUENCER
		= "INSERT INTO KEYSEQ (NAME, SEQ) VALUES (?, 0) ";
	/** V[PT̒lXV邽߂SQL */
	private static final String SQL_UPDATE_SEQUENCER
		= "UPDATE KEYSEQ SET SEQ = ? WHERE (NAME = ?) AND (SEQ < ?) ";
	/** V[PT̒l擾邽߂SQL */
	private static final String SQL_GET_SEQUENCER
		= "SELECT SEQ FROM KEYSEQ WHERE NAME = ? ";

	/**
	 * V[PXǗe[uɑ΂ANZXIuWFNg𐶐B
	 *
	 * @param conn RlNV
	 */
	MySQLSequencerDAO(Connection conn)
	{
		super(conn);
	}

	/**
	 * ̃V[PXlint͈͓̔Ŏ擾B
	 *
	 * @param seqName V[PT
	 * @return V[PXl
	 * @throws SQLException SQLO
	 */
	public int nextForInt(String seqName) throws SQLException
	{
		long seq = next(seqName);
		if (seq > Integer.MAX_VALUE) {
			throw new ArithmeticException("Value is out of INTEGER range.");
		}
		return (int)seq;
	}

	/**
	 * ̃V[PXl擾B
	 *
	 * @param seqName V[PT
	 * @return V[PXl
	 * @throws SQLException SQLO
	 */
	public long next(String seqName) throws SQLException
	{
		Connection conn = getConnection();
		init(conn, seqName);
		long seq = current(conn, seqName);

		int result = 0;
		PreparedStatement statement = conn.prepareStatement(SQL_UPDATE_SEQUENCER);
		try {
			while (result < 1) {
				seq++;
				statement.setLong(1, seq);
				statement.setString(2, seqName);
				statement.setLong(3, seq);

				/************** DEBUG **************/
				eLog.debug(statement.toString());
				/***********************************/
				result = statement.executeUpdate();
			}
		} finally {
			statement.close();
		}
		return seq;
	}

	/**
	 * V[PTB
	 *
	 * @param conn     JDBCڑ
	 * @param seqName V[PT
	 * @throws SQLException SQLO
	 */
	private void init(Connection conn, String seqName)
	throws SQLException
	{
		PreparedStatement statement = conn.prepareStatement(SQL_INSERT_SEQUENCER);
		try {
			statement.setString(1, seqName);

			/************** DEBUG **************/
			eLog.debug(statement.toString());
			/***********************************/

			int i = statement.executeUpdate();
		} catch (SQLException ex) {
			//R[h}ŗONĂƂ肠B
		} finally {
			statement.close();
		}
	}

	/**
	 * ݂̃V[PXl擾B
	 *
	 * @param conn    JDBCڑ
	 * @param seqName V[PT
	 * @return V[PXl
	 * @throws SQLException SQLO
	 */
	private long current(Connection conn, String seqName)
	throws SQLException
	{
		PreparedStatement statement = conn.prepareStatement(SQL_GET_SEQUENCER);
		try {
			statement.setString(1, seqName);

			/************** DEBUG **************/
			eLog.debug(statement.toString());
			/***********************************/

			long seq = -1L;
			ResultSet rs = statement.executeQuery();
			if (rs.next()) {
				seq = rs.getLong(SEQ);
			}
			rs.close();

			return seq;
		} finally {
			statement.close();
		}
	}
}
