/* $Id: MySQLSourceActivityDAO.java,v 1.12 2005/08/26 04:54:37 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.SourceActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.SourceActivityDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * SourceActivityBeanf[^ƂMySQLpDAONXłB
 * <pre><tt>
 * ETAACTIVITYe[u
 * +--------------+-------------+------+-----+---------+-------+
 * | Field        | Type        | Null | Key | Default | Extra |
 * +--------------+-------------+------+-----+---------+-------+
 * | PROCESS_ID   | varchar(64) |      | PRI |         |       |
 * | ENGINE_ID    | varchar(64) |      |     |         |       |
 * | ROOT_PROC_ID | varchar(64) |      |     |         |       |
 * | ROOT_ACT_ID  | varchar(64) |      |     |         |       |
 * +--------------+-------------+------+-----+---------+-------+
 * </tt></pre>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.12 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLSourceActivityDAO extends AbstractDAO implements SourceActivityDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/** vZXID̃J */
	static public final String PROCESS_ID   = "PROCESS_ID";
	/** GWID̃J */
	static public final String ENGINE_ID    = "ENGINE_ID";
	/** [gvZXID̃J */
	static public final String ROOT_PROC_ID = "ROOT_PROC_ID";
	/** [gANeBreBID̃J */
	static public final String ROOT_ACT_ID  = "ROOT_ACT_ID";

	static private final String SQL_SELECT_BY_PRIMARY_KEY
	= "select * from ETAACTIVITY where PROCESS_ID = ? ";

	static private final String SQL_INSERT
	= "insert into ETAACTIVITY ("
		+ PROCESS_ID + ", "
		+ ENGINE_ID + ", "
		+ ROOT_PROC_ID + ", "
		+ ROOT_ACT_ID + ") values (?,?,?,?)";

	private static final String SQL_DELETE
	= "delete from ETAACTIVITY where PROCESS_ID = ? ";

	/**
	 * vZXǗe[uɑ΂ANZXIuWFNg𐶐B
	 *
	 * @param conn RlNV
	 */
	MySQLSourceActivityDAO(Connection conn)
	{
		super(conn);
	}
	
	/**
	 * NvZXIDŋNANeBreB擾B
	 *
	 * @param pid vZXID
	 * @return NANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.SourceActivityDAO#findByPrimaryKey(java.lang.String)
	 */
	public SourceActivityBean findByPrimaryKey(String pid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
		try {
			st.setString(1, pid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			SourceActivityBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}
	
	/**
	 * NANeBreB}B
	 *
	 * @param bean NANeBreB
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.SourceActivityDAO#insert(jp.co.argo21.nautica.workflow.dataaccess.SourceActivityBean)
	 */
	public void insert(SourceActivityBean bean)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_INSERT);
		try {
			st.setString(1, bean.getProcessID());
			st.setString(2, bean.getEngineID());
			st.setString(3, bean.getRootProcID());
			st.setString(4, bean.getRootActID());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// OvZXNANeBreB̑}Ɏs܂B
				String errMsg = StringManager.get("E0026");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}

	/**
	 * NvZXIDœ肳NANeBreB폜B
	 *
	 * @param pid vZXID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.SourceActivityDAO#delete(java.lang.String)
	 */
	public void delete(String pid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_DELETE);
		try {
			st.setString(1, pid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// OvZXNANeBreB̍폜Ɏs܂B
				String errMsg = StringManager.get("E0025");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}

	/**
	 * ʃZbgNANeBreB쐬B
	 *
	 * @param rs ʃZbg
	 * @return NANeBreB
	 * @throws SQLException CӂSQLO
	 */
	private SourceActivityBean createBean(ResultSet rs)
	throws SQLException
	{
		SourceActivityBean bean = new SourceActivityBean();

		bean.setProcessID(rs.getString(PROCESS_ID));
		bean.setEngineID(rs.getString(ENGINE_ID));
		bean.setRootProcID(rs.getString(ROOT_PROC_ID));
		bean.setRootActID(rs.getString(ROOT_ACT_ID));
		
		return bean;
	}
}
