/* $Id: MySQLTargetProcessDAO.java,v 1.12 2005/08/26 04:54:43 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * TargetProcessBeanf[^ƂMySQLpDAONXłB
 * <pre><tt>
 * ETAPROCESSe[u
 * +--------------+-------------+------+-----+---------+-------+
 * | Field        | Type        | Null | Key | Default | Extra |
 * +--------------+-------------+------+-----+---------+-------+
 * | ENGINE_ID    | varchar(64) |      | PRI |         |       |
 * | PROCESS_ID   | varchar(64) |      | PRI |         |       |
 * | ROOT_PROC_ID | varchar(64) |      |     |         |       |
 * | ROOT_ACT_ID  | varchar(64) |      |     |         |       |
 * +--------------+-------------+------+-----+---------+-------+
 * </tt></pre>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.12 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLTargetProcessDAO extends AbstractDAO implements TargetProcessDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/** GWID̃J */
	static public final String ENGINE_ID    = "ENGINE_ID";
	/** vZXID̃J */
	static public final String PROCESS_ID   = "PROCESS_ID";
	/** [gvZXID̃J */
	static public final String ROOT_PROC_ID = "ROOT_PROC_ID";
	/** [gANeBreBID̃J */
	static public final String ROOT_ACT_ID  = "ROOT_ACT_ID";

	static private final String SQL_SELECT_BY_PRIMARY_KEY
	= "select * from ETAPROCESS where ENGINE_ID = ? AND PROCESS_ID = ? ";

	static private final String SQL_SELECT_BY_PROC_ID
	= "select * from ETAPROCESS where PROCESS_ID = ? ";

	static private final String SQL_SELECT_BY_ROOT_ID
	= "select * from ETAPROCESS where ROOT_PROC_ID = ? AND ROOT_ACT_ID = ? ";

	static private final String SQL_INSERT
	= "insert into ETAPROCESS ("
		+ ENGINE_ID + ", "
		+ PROCESS_ID + ", "
		+ ROOT_PROC_ID + ", "
		+ ROOT_ACT_ID + ") values (?,?,?,?)";

	private static final String SQL_DELETE
	= "delete from ETAPROCESS where ENGINE_ID = ? AND PROCESS_ID = ? ";

	/**
	 * vZXǗe[uɑ΂ANZXIuWFNg𐶐B
	 *
	 * @param conn RlNV
	 */
	MySQLTargetProcessDAO(Connection conn)
	{
		super(conn);
	}
	
	/**
	 * GWIDƋNvZXIDŋNvZX擾B
	 *
	 * @param eid GWID
	 * @param pid vZXID
	 * @return NvZX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO#findByPrimaryKey(java.lang.String, java.lang.String)
	 */
	public TargetProcessBean findByPrimaryKey(String eid, String pid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
		try {
			st.setString(1, eid);
			st.setString(2, pid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			TargetProcessBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}

	/**
	 * NvZXIDŋNvZX擾B
	 *
	 * @param pid vZXID
	 * @return NvZX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO#findByProcessID(java.lang.String)
	 */
	public TargetProcessBean findByProcessID(String pid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PROC_ID);
		try {
			st.setString(1, pid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			TargetProcessBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}

	/**
	 * NvZXIDƋNANeBreBIDŋNvZX擾B
	 *
	 * @param rootpid NvZXID
	 * @param rootaid NANeBreBID
	 * @return NvZX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO#findByRootID(java.lang.String, java.lang.String)
	 */
	public TargetProcessBean findByRootID(String rootpid, String rootaid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_ROOT_ID);
		try {
			st.setString(1, rootpid);
			st.setString(2, rootaid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			TargetProcessBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}

	/**
	 * NvZX}B
	 *
	 * @param bean NvZX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO#insert(jp.co.argo21.nautica.workflow.dataaccess.TargetProcessBean)
	 */
	public void insert(TargetProcessBean bean)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_INSERT);
		try {
			st.setString(1, bean.getEngineID());
			st.setString(2, bean.getProcessID());
			st.setString(3, bean.getRootProcID());
			st.setString(4, bean.getRootActID());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// OvZXN̑}Ɏs܂B
				String errMsg = StringManager.get("E0028");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}

	/**
	 * NvZX폜B
	 *
	 * @param eid GWID
	 * @param pid vZXID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO#delete(java.lang.String, java.lang.String)
	 */
	public void delete(String eid, String pid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_DELETE);
		try {
			st.setString(1, eid);
			st.setString(2, pid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// OvZXN̍폜Ɏs܂B
				String errMsg = StringManager.get("E0027");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}
	
	/**
	 * ʃZbgNvZX쐬B
	 *
	 * @param rs ʃZbg
	 * @return NvZX
	 * @throws SQLException CӂSQLO
	 */
	private TargetProcessBean createBean(ResultSet rs)
	throws SQLException
	{
		TargetProcessBean bean = new TargetProcessBean();

		bean.setEngineID(rs.getString(ENGINE_ID));
		bean.setProcessID(rs.getString(PROCESS_ID));
		bean.setRootProcID(rs.getString(ROOT_PROC_ID));
		bean.setRootActID(rs.getString(ROOT_ACT_ID));
		
		return bean;
	}
}
