/* $Id: MySQLUserManagerDAO.java,v 1.6 2005/08/26 04:54:42 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.UserBean;
import jp.co.argo21.nautica.workflow.dataaccess.UserManagerDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;

/**
 * UserBeanf[^ƂMySQLpDAONXłB
 * <pre><tt>
 * USERe[u
 * +--------------+-------------+------+-----+---------+-------+
 * | Field        | Type        | Null | Key | Default | Extra |
 * +--------------+-------------+------+-----+---------+-------+
 * | USER_ID      | varchar(64) |      | PRI |         |       |
 * | FIRST_NAME   | varchar(64) |      |     |         |       |
 * | LAST_NAME    | varchar(64) |      |     |         |       |
 * | PASSWORD     | varchar(64) |      |     |         |       |
 * | MAIL_ADDRESS | varchar(64) |      |     |         |       |
 * +--------------+-------------+------+-----+---------+-------+
 * </tt></pre>
 * ́AJL[lƂĂB
 * J̑啶Ɋւ炸ÃL[l͑啶Őݒ肳B
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLUserManagerDAO extends AbstractDAO
implements UserManagerDAO {
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

     /** [UID̃J */
    private static final String USER_ID = "USER_ID";
    /** t@~[l[̃J */
    private static final String FIRST_NAME = "FIRST_NAME";
    /** t@[Xgl[̃J */
    private static final String LAST_NAME = "LAST_NAME";
    
    private static final String SQL_SELECT_BY_USER_ID
        = "select * from USER where USER_ID = ?";
    
    /**
     * [Ue[uɑ΂ANZXIuWFNg𐶐B
     * 
     * @param conn RlNV
     */
    MySQLUserManagerDAO(Connection conn) {
        super(conn);
    }

    /**
     * w肳ꂽ[UID̃[UԂB
     * Y郆[U񂪑݂Ȃꍇ null ԂB
     * 
     * @param uid [UID
     * @return w肳ꂽ[UID̏UserBean
	 * @throws SQLException CӂSQLO
     * @see jp.co.argo21.nautica.workflow.dataaccess.UserManagerDAO#findByUserID(java.lang.String)
     */
    public UserBean findByUserID(String uid) throws SQLException {
        
        PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_USER_ID);
		try {
			st.setString(1, uid);			

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/

			ResultSet rs = st.executeQuery();
			
			UserBean bean = null;
			if (rs.next()) {
			    bean = createBean(rs);
			}
					
			return bean;
			
		} finally {
			st.close();
		}
    }

    /**
     * ResultSet̏񂩂UserBean쐬B
     * 
     * @param  rs ResultSet
     * @return ResultSet擾UserBean
	 * @throws SQLException CӂSQLO
     */
    static UserBean createBean(ResultSet rs) throws SQLException {
        /* J擾 */
        List columnNames = new ArrayList();
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); i++) {
            columnNames.add(rs.getMetaData().getColumnName(i));
        }

        UserBean bean = new UserBean();
        for (int i = 0; i < columnNames.size(); i++) {            
            String columnName = ((String) columnNames.get(i)).toUpperCase();
            String attribute = (String) rs.getObject(columnName);

            /* [UIDݒ */
            if (columnName.equals(USER_ID)) {
                bean.setID(attribute);
            }
            
            /* t@[Xgl[ݒ */
            if (columnName.equals(FIRST_NAME)) {
                bean.setFirstName(attribute);                
            }
            
            /* Xgl[ݒ */
            if (columnName.equals(LAST_NAME)) {
                bean.setLastName(attribute);                
            }

            /* [UIDAt@[Xgl[AXgl[ȊȌ[Uɐݒ */
            if (!columnName.equals(USER_ID)
                    && !columnName.equals(FIRST_NAME)
                    && !columnName.equals(LAST_NAME)) {
                bean.setAttribute(columnName, attribute);
            }
        }
        return bean;
    }    
}