/* $Id: MySQLVariableDAO.java,v 1.18 2005/08/26 04:54:47 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.VariableHistoryBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableHistoryDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * VariableBeanf[^ƂMySQLpDAONXłB
 * <pre><tt>
 * VARIABLEe[u
 * +-------------+--------------+------+-----+---------+-------+
 * | Field       | Type         | Null | Key | Default | Extra |
 * +-------------+--------------+------+-----+---------+-------+
 * | VAR_ID      | varchar(64)  |      | PRI |         |       |
 * | NAME        | varchar(128) |      |     |         |       |
 * | PROC_ID     | varchar(64)  |      | MUL |         |       |
 * | VAR_DEF_ID  | varchar(64)  |      |     |         |       |
 * | TYPE        | int(1)       |      |     | 0       |       |
 * | VALUE       | text         |      |     |         |       |
 * | UPDATE_DATE | datetime     | YES  |     | NULL    |       |
 * +-------------+--------------+------+-----+---------+-------+
 * </tt></pre>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.18 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLVariableDAO extends AbstractDAO implements VariableDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/** vZXϐID̃J */
	static public final String VAR_ID      = "VAR_ID";
	/** vZXϐ̃J */
	static public final String NAME        = "NAME";
	/** vZXID̃J */
	static public final String PROC_ID     = "PROC_ID";
	/** vZXϐ`ID̃J */
	static public final String VAR_DEF_ID  = "VAR_DEF_ID";
	/** vZXϐ^CṽJ */
	static public final String TYPE        = "TYPE";
	/** vZXϐl̃J */
	static public final String VALUE       = "VALUE";
	/** XṼJ */
	static public final String UPDATE_DATE = "UPDATE_DATE";

	static private final String SQL_SELECT_BY_PRIMARY_KEY
	= "select * from VARIABLE where PROC_ID = ? AND VAR_ID = ? ";

	static private final String SQL_SELECT_BY_DEFINITION_ID
	= "select * from VARIABLE where PROC_ID = ? AND VAR_DEF_ID = ? ";

	static private final String SQL_SELECT_BY_PROCEESS_ID
	= "select * from VARIABLE where PROC_ID = ? ";

	static private final String SQL_SELECT_BY_PROCEESS_ID_AND_NAME
	= "select * from VARIABLE where PROC_ID = ? AND NAME = ? ";

	static private final String SQL_INSERT
	= "insert into VARIABLE ("
		+ VAR_ID + ", "
		+ NAME + ", "
		+ PROC_ID + ", "
		+ VAR_DEF_ID + ", "
		+ TYPE + ", "
		+ VALUE + ", "
		+ UPDATE_DATE + ") values (?,?,?,?,?,?,?)";

	static private final String SQL_UPDATE
	= "update  VARIABLE set "
		+ VALUE + " = ?, "
		+ UPDATE_DATE + " = ? where PROC_ID = ? AND NAME = ? AND TYPE = ? ";

	/**
	 * vZXǗe[uɑ΂ANZXIuWFNg𐶐B
	 *
	 * @param conn RlNV
	 */
	MySQLVariableDAO(Connection conn)
	{
		super(conn);
	}
	
	/**
	 * vZXIDƃvZXϐIDŃvZXϐ擾B
	 *
	 * @param pid vZXID
	 * @param vid vZXϐID
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.VariableDAO#findByPrimaryKey(java.lang.String, java.lang.String)
	 */
	public VariableBean findByPrimaryKey(String pid, String vid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
		try {
			st.setString(1, pid);
			st.setString(2, vid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			VariableBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}


	/**
	 * vZXIDƃvZXϐ`IDŃvZXϐ擾B
	 *
	 * @param pid vZXID
	 * @param vdid vZXϐ`ID
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.VariableDAO#findByDefinitionID(java.lang.String, java.lang.String)
	 */
	public VariableBean findByDefinitionID(String pid, String vdid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_DEFINITION_ID);
		try {
			st.setString(1, pid);
			st.setString(2, vdid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			VariableBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}
	
	/**
	 * vZXIDƃvZXϐŃvZXϐ擾B
	 *
	 * @param pid vZXID
	 * @param name vZXϐ
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.VariableDAO#findByName(java.lang.String, java.lang.String)
	 */
	public VariableBean findByName(String pid, String name)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PROCEESS_ID_AND_NAME);
		try {
			st.setString(1, pid);
			st.setString(2, name);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			VariableBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}
	
	/**
	 * vZXIDƃvZXϐIDŃvZXϐ擾B
	 *
	 * @param pid vZXID
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.VariableDAO#findByProcessID(java.lang.String)
	 */
	public VariableBean[] findByProcessID(String pid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PROCEESS_ID);
		try {
			st.setString(1, pid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();

			List beans = new ArrayList();
			while (rs.next()) {
				VariableBean bean = createBean(rs);
				beans.add(bean);
			}
			return (VariableBean[])beans.toArray(new VariableBean[beans.size()]);
		} finally {
			st.close();
		}
	}
	
	/**
	 * XgƂăvZXID^B
	 *
	 * @param pid vZXID
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.VariableDAO#findByProcessID(java.lang.String)
	 */
	public List findByProcessIDAsList(String pid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PROCEESS_ID);
		try {
			st.setString(1, pid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();

			List beans = new ArrayList();
			while (rs.next()) {
				VariableBean bean = createBean(rs);
				beans.add(bean);
			}
			return beans;
		} finally {
			st.close();
		}
	}
	
	/**
	 * vZXIDSQLŃvZXϐ擾B
	 *
	 * @param pid vZXID
	 * @param sqlPart SQL
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.VariableDAO#findBySQLPart(java.lang.String, java.lang.String)
	 */
	public VariableBean[] findBySQLPart(String pid, String sqlPart)
	throws SQLException, DAOException
	{
		String sql = SQL_SELECT_BY_PROCEESS_ID;
		if (sqlPart != null && sqlPart.trim().equals("") == false) {
			sql += " AND " + sqlPart;
		}
		PreparedStatement st = getConnection().prepareStatement(sql);
		try {
			st.setString(1, pid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();

			List beans = new ArrayList();
			while (rs.next()) {
				VariableBean bean = createBean(rs);
				beans.add(bean);
			}
			return (VariableBean[])beans.toArray(new VariableBean[beans.size()]);
		} finally {
			st.close();
		}
	}
	
	/**
	 * vZXϐ}B
	 *
	 * @param bean vZXϐ
	 * @param actid ANeBreBID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.VariableDAO#insert(jp.co.argo21.nautica.workflow.dataaccess.VariableBean, java.lang.String)
	 */
	public void insert(VariableBean bean, String actid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_INSERT);
		try {
			st.setString(1, bean.getID());
			st.setString(2, bean.getName());
			st.setString(3, bean.getProcessID());
			st.setString(4, bean.getVariableDefinitionID());
			st.setInt(5, bean.getType());
			st.setString(6, bean.getValue());
			st.setTimestamp(7, bean.getUpdateDate());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// vZXϐ̑}Ɏs܂B
				String errMsg = StringManager.get("E0029");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}

		try {
			WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
			VariableHistoryDAO ahDAO = factory.getVariableHistoryDAO();
			VariableHistoryBean history = new VariableHistoryBean();
			history.setVarID(bean.getID());
			history.setProcID(bean.getProcessID());
			history.setVarDefID(bean.getVariableDefinitionID());
			history.setType(bean.getType());
			history.setPrevValue(null);
			history.setNewValue(bean.getValue());
			history.setUpdateDate(bean.getUpdateDate());
			history.setReason("NEW VAR CREATION");
			history.setActivityID(actid);
			ahDAO.insert(history);
		} catch (SQLException ex) {
			throw ex;
		} catch (DAOException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐύX̕ύXɎs܂B
			String errMsg = StringManager.get("E0030");
			throw new DAOException(errMsg, ex);
		}
	}
	
	/**
	 * vZXϐXVB
	 *
	 * @param bean vZXϐ
	 * @param value l̕\
	 * @param actid ANeBreBID
	 * @param ts ^CX^v
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.VariableDAO#update(jp.co.argo21.nautica.workflow.dataaccess.VariableBean, java.lang.String, java.lang.String, java.sql.Timestamp)
	 */
	public void update(VariableBean bean, String value, String actid, Timestamp ts)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_UPDATE);
		try {
			st.setString(1, value);
			st.setTimestamp(2, ts);
			st.setString(3, bean.getProcessID());
			st.setString(4, bean.getName());
			st.setInt(5, bean.getType());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// vZXϐ̍XVɎs܂B
				String errMsg = StringManager.get("E0031");
				throw new DAOException(errMsg);
			}
			bean.setValue(value);
			bean.setUpdateDate(ts);
		} finally {
			st.close();
		}

		try {
			WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
			VariableHistoryDAO ahDAO = factory.getVariableHistoryDAO();
			VariableHistoryBean history = new VariableHistoryBean();
			history.setVarID(bean.getID());
			history.setProcID(bean.getProcessID());
			history.setVarDefID(bean.getVariableDefinitionID());
			history.setType(bean.getType());
			history.setPrevValue(null);
			history.setNewValue(bean.getValue());
			history.setUpdateDate(bean.getUpdateDate());
			history.setActivityID(actid);
			String msg = "VARIABLE CHANGED";
			history.setReason(msg);
			ahDAO.insert(history);
		} catch (SQLException ex) {
			throw ex;
		} catch (DAOException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐύX̕ύXɎs܂B
			String errMsg = StringManager.get("E0030");
			throw new DAOException(errMsg, ex);
		}
	}
	
	/**
	 * ʃZbgvZXϐ쐬B
	 *
	 * @param rs ʃZbg
	 * @return vZXϐ
	 * @throws SQLException CӂSQLO
	 */
	private VariableBean createBean(ResultSet rs)
	throws SQLException
	{
		VariableBean bean = new VariableBean();

		bean.setID(rs.getString(VAR_ID));
		bean.setName(rs.getString(NAME));
		bean.setProcessID(rs.getString(PROC_ID));
		bean.setVariableDefinitionID(rs.getString(VAR_DEF_ID));
		bean.setType(rs.getInt(TYPE));
		bean.setValue(rs.getString(VALUE));
		bean.setUpdateDate(rs.getTimestamp(UPDATE_DATE));
		
		return bean;
	}
}
