/* $Id: MySQLVariableHistoryDAO.java,v 1.11 2005/08/26 04:54:45 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.VariableHistoryBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableHistoryDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * VariableHistoryBeanf[^ƂMySQLpDAONXłB
 * <pre><tt>
 * VARIABLEHISTe[u
 * +-------------+--------------+------+-----+---------------------+-------+
 * | Field       | Type         | Null | Key | Default             | Extra |
 * +-------------+--------------+------+-----+---------------------+-------+
 * | VAR_ID      | varchar(64)  |      | PRI |                     |       |
 * | PROC_ID     | varchar(64)  |      |     |                     |       |
 * | VAR_DEF_ID  | varchar(64)  |      |     |                     |       |
 * | TYPE        | int(1)       |      |     | 0                   |       |
 * | PREV_VALUE  | text         | YES  |     | NULL                |       |
 * | NEW_VALUE   | text         |      |     |                     |       |
 * | UPDATE_DATE | datetime     |      |     | 0000-00-00 00:00:00 |       |
 * | REASON      | varchar(128) | YES  |     | NULL                |       |
 * | ACT_ID      | varchar(64)  | YES  |     | NULL                |       |
 * +-------------+--------------+------+-----+---------------------+-------+
 * </tt></pre>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.11 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLVariableHistoryDAO extends AbstractDAO implements VariableHistoryDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/** vZXϐID̃J */
	static public final String VAR_ID      = "VAR_ID";
	/** vZXID̃J */
	static public final String PROC_ID     = "PROC_ID";
	/** vZXϐ`ID̃J */
	static public final String VAR_DEF_ID  = "VAR_DEF_ID";
	/** vZXϐ^CṽJ */
	static public final String TYPE        = "TYPE";
	/** O̒l̃J */
	static public final String PREV_VALUE  = "PREV_VALUE";
	/** Vl̃J */
	static public final String NEW_VALUE   = "NEW_VALUE";
	/** XṼJ */
	static public final String UPDATE_DATE = "UPDATE_DATE";
	/** XVR̃J */
	static public final String REASON      = "REASON";
	/** ANeBreBID̃J */
	static public final String ACT_ID      = "ACT_ID";

	static private final String SQL_INSERT
	= "insert into VARIABLEHIST ("
		+ VAR_ID + ", "
		+ PROC_ID + ", "
		+ VAR_DEF_ID + ", "
		+ TYPE + ", "
		+ PREV_VALUE + ", "
		+ NEW_VALUE + ", "
		+ UPDATE_DATE + ", "
		+ REASON + ", "
		+ ACT_ID + ") values (?,?,?,?,?,?,?,?,?)";

	/**
	 * vZXǗe[uɑ΂ANZXIuWFNg𐶐B
	 *
	 * @param conn RlNV
	 */
	MySQLVariableHistoryDAO(Connection conn)
	{
		super(conn);
	}
		
	/**
	 * vZXϐύX}B
	 *
	 * @param bean vZXϐύX
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.VariableHistoryDAO#insert(jp.co.argo21.nautica.workflow.dataaccess.VariableHistoryBean)
	 */
	public void insert(VariableHistoryBean bean)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_INSERT);
		try {
			st.setString(1, bean.getVarID());
			st.setString(2, bean.getProcID());
			st.setString(3, bean.getVarDefID());
			st.setInt(4, bean.getType());
			st.setString(5, bean.getPrevValue());
			st.setString(6, bean.getNewValue());
			st.setTimestamp(7, bean.getUpdateDate());
			st.setString(8, bean.getReason());
			st.setString(9, bean.getActivityID());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// vZXϐύX̑}Ɏs܂B
				String errMsg = StringManager.get("E0033");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}
	
	/**
	 * ʃZbgvZXϐύX쐬B
	 *
	 * @param rs ʃZbg
	 * @return vZXϐύX
	 * @throws SQLException CӂSQLO
	 */
	private VariableHistoryBean createBean(ResultSet rs)
	throws SQLException
	{
		VariableHistoryBean bean = new VariableHistoryBean();

		bean.setVarID(rs.getString(VAR_ID));
		bean.setProcID(rs.getString(PROC_ID));
		bean.setVarDefID(rs.getString(VAR_DEF_ID));
		bean.setType(rs.getInt(TYPE));
		bean.setPrevValue(rs.getString(PREV_VALUE));
		bean.setNewValue(rs.getString(NEW_VALUE));
		bean.setUpdateDate(rs.getTimestamp(UPDATE_DATE));
		bean.setReason(rs.getString(REASON));
		bean.setActivityID(rs.getString(ACT_ID));
		
		return bean;
	}
}
