/* $Id: MySQLWorkItemDAO.java,v 1.25 2005/08/26 04:54:48 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemBean;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Participant;

/**
 * WorkItemBeanf[^ƂMySQLpDAONXłB
 * <pre><tt>
 * WORKITEMe[u
 * +------------------+--------------+------+-----+---------+-------+
 * | Field            | Type         | Null | Key | Default | Extra |
 * +------------------+--------------+------+-----+---------+-------+
 * | WORK_ID          | varchar(64)  |      | PRI |         |       |
 * | PROC_ID          | varchar(64)  |      | MUL |         |       |
 * | ACT_ID           | varchar(64)  |      |     |         |       |
 * | PARTICIPANT_TYPE | int(1)       | YES  |     | NULL    |       |
 * | PARTICIPANT_NAME | varchar(128) | YES  |     | NULL    |       |
 * +------------------+--------------+------+-----+---------+-------+
 * </tt></pre>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.25 $
 * @since   Nautica Workflow 0.9
 */
public class MySQLWorkItemDAO extends AbstractDAO implements WorkItemDAO
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/**@ƍID̃J */
	static public final String WORK_ID          = "WORK_ID";
	/**@vZXID̃J */
	static public final String PROC_ID          = "PROC_ID";
	/**@ANeBreBID̃J */
	static public final String ACT_ID           = "ACT_ID";
	/**@QҌ^̃J */
	static public final String PARTICIPANT_TYPE = "PARTICIPANT_TYPE";
	/**@QҖ̃J */
	static public final String PARTICIPANT_NAME = "PARTICIPANT_NAME";

	static private final String SQL_SELECT_BY_PRIMARY_KEY
	= "select * from WORKITEM where WORK_ID = ? ";

	static private final String SQL_SELECT_BY_PID_AND_AID
	= "select * from WORKITEM where PROC_ID = ? AND ACT_ID = ? ";

	static private final String SQL_SELECT_COUNT_BY_PARTICIPANT
	= "select count(*) from WORKITEM where PARTICIPANT_NAME = ? and PARTICIPANT_TYPE = ? ";

	static private final String SQL_SELECT_BY_PARTICIPANT
	= "select * from WORKITEM where  PARTICIPANT_NAME = ? and PARTICIPANT_TYPE = ? ";

	static private final String SQL_SELECT_WITH_VAR
	= "select distinct w.* from WORKITEM w, VARIABLE v ";

	static private final String SQL_SELECT
	= "select distinct w.* from WORKITEM w ";

	static private final String SQL_INSERT
	= "insert into WORKITEM ("
		+ WORK_ID + ", "
		+ PROC_ID + ", "
		+ ACT_ID + ", "
		+ PARTICIPANT_TYPE + ", "
		+ PARTICIPANT_NAME + ") values (?,?,?,?,?)";

	private static final String SQL_UPDATE_PARTICIPANT
	= "update WORKITEM set PARTICIPANT_TYPE = ?, PARTICIPANT_NAME = ? where WORK_ID = ? and PARTICIPANT_TYPE = ? and PARTICIPANT_NAME = ? ";

	private static final String SQL_DELETE
	= "delete from WORKITEM where WORK_ID = ? ";

	private static final String SQL_DELETE_BY_PID_AND_AID
	= "delete from WORKITEM where PROC_ID = ? AND ACT_ID = ? ";

	/**
	 * vZXǗe[uɑ΂ANZXIuWFNg𐶐B
	 *
	 * @param conn RlNV
	 */
	MySQLWorkItemDAO(Connection conn)
	{
		super(conn);
	}
	
	/**
	 * ƍIDōƍڂ擾B
	 *
	 * @param wid ƍID
	 * @return ƍ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO#findByPrimaryKey(java.lang.String)
	 */
	public WorkItemBean findByPrimaryKey(String wid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
		try {
			st.setString(1, wid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			WorkItemBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}

	/**
	 * vZXIDƃANeBreBIDōƍڂ擾B
	 *
	 * @param pid vZXID
	 * @param aid ANeBreBID
	 * @return ƍ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO#findByProcessIDANDActivityID(java.lang.String, java.lang.String)
	 */
	public WorkItemBean findByProcessIDANDActivityID(String pid, String aid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PID_AND_AID);
		try {
			st.setString(1, pid);
			st.setString(2, aid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			WorkItemBean bean = null;
			if (rs.next()) {
				bean = createBean(rs);
			}
			return bean;
		} finally {
			st.close();
		}
	}

	/**
	 * [Nt[QҖƌ^ōƍڂ̌擾B
	 *
	 * @param name [Nt[QҖ
	 * @param type [Nt[QҌ^
	 * @return ƍڂ̌
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO#findCountByParticipant(java.lang.String, int)
	 */
	public int findCountByParticipant(String name, int type)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_COUNT_BY_PARTICIPANT);
		try {
			st.setString(1, name);
			st.setInt(2, type);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			int count = 0;
			if (rs.next()) {
				count = rs.getInt(1);
			}
			return count;
		} finally {
			st.close();
		}
	}
	
	/**
	 * [Nt[QҖƌ^ōƍڂ擾B
	 *
	 * @param name [Nt[QҖ
	 * @param type [Nt[QҌ^
	 * @return ƍ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO#findByParticipant(java.lang.String, int)
	 */
	public WorkItemBean[] findByParticipant(String name, int type)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_SELECT_BY_PARTICIPANT);
		try {
			st.setString(1, name);
			st.setInt(2, type);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			ResultSet rs = st.executeQuery();
			
			List beans = new ArrayList();
			while (rs.next()) {
				WorkItemBean bean = createBean(rs, "w.");
				beans.add(bean);
			}
			return (WorkItemBean[])beans.toArray(new WorkItemBean[beans.size()]);
		} finally {
			st.close();
		}
	}
	
	/**
	 * SQLɂāAƍڂ擾B
	 *
	 * @param s SQL
	 * @param hasAttrbuteFilter tB^[܂ޏꍇtrue
	 * @return ƍ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO#findBySQLPart(java.lang.String, boolean)
	 */
	public WorkItemBean[] findBySQLPart(String s, boolean hasAttrbuteFilter)
	throws SQLException, DAOException
	{
		PreparedStatement st = null;
		if (hasAttrbuteFilter) {
			st = getConnection().prepareStatement(SQL_SELECT_WITH_VAR + s);
		} else {
			st = getConnection().prepareStatement(SQL_SELECT + s);
		}
		try {

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/

			ResultSet rs = st.executeQuery();
			
			List beans = new ArrayList();
			while (rs.next()) {
				WorkItemBean bean = createBean(rs, "w.");
				beans.add(bean);
			}
			return (WorkItemBean[])beans.toArray(new WorkItemBean[beans.size()]);
		} finally {
			st.close();
		}
	}
	
	/**
	 * ƍڂ}B
	 *
	 * @param bean ƍ
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO#insert(jp.co.argo21.nautica.workflow.dataaccess.WorkItemBean)
	 */
	public void insert(WorkItemBean bean)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_INSERT);
		try {
			st.setString(1, bean.getID());
			st.setString(2, bean.getProcessID());
			st.setString(3, bean.getActivityID());
			st.setInt(4, bean.getParticipantType());
			st.setString(5, bean.getParticipantName());

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// ƍڂ̑}Ɏs܂B
				String errMsg = StringManager.get("E0035");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}
	
	/**
	 * ƍڂ̃[Nt[Q҂XVB
	 *
	 * @param wid ƍID
	 * @param src XVÕ[Nt[Q
	 * @param target XṼ[Nt[Q
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO#updateParticipant(java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Participant, jp.co.argo21.nautica.workflow.wfmc.Participant)
	 */
	public void updateParticipant(String wid, Participant src, Participant target)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_UPDATE_PARTICIPANT);
		try {
			if (target == null) {
				st.setNull(1, Types.INTEGER);
				st.setNull(2, Types.VARCHAR);
				st.setString(3, wid);
				st.setInt(4, src.getType());
				st.setString(5, src.getID());
			} else {
				st.setInt(1, target.getType());
				st.setString(2, target.getID());
				st.setString(3, wid);
				st.setInt(4, src.getType());
				st.setString(5, src.getID());
			}

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// ƍڂ̒S҂̕ύXɎs܂B
				String errMsg = StringManager.get("E0036");
				throw new DAOException(errMsg);
			}
		} catch (WorkflowException ex) {
			// ƍڂ̒S҂̕ύXɎs܂B
			String errMsg = StringManager.get("E0036");
			throw new DAOException(errMsg, ex);
		} finally {
			st.close();
		}
	}
	
	/**
	 * ƍڂ폜B
	 *
	 * @param wid ƍID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO#delete(java.lang.String)
	 */
	public void delete(String wid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_DELETE);
		try {
			st.setString(1, wid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// ƍڂ̍폜Ɏs܂B
				String errMsg = StringManager.get("E0034");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}

	/**
	 * vZXIDƃANeBreBIDōƍڂ擾B
	 *
	 * @param pid vZXID
	 * @param aid ANeBreBID
	 * @throws SQLException CӂSQLO
	 * @throws DAOException DAOsɏƂĂꍇO
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO#deleteByProcessIDANDActivityID(java.lang.String, java.lang.String)
	 */
	public void deleteByProcessIDANDActivityID(String pid, String aid)
	throws SQLException, DAOException
	{
		PreparedStatement st = getConnection().prepareStatement(SQL_DELETE_BY_PID_AND_AID);
		try {
			st.setString(1, pid);
			st.setString(2, aid);

			/************** DEBUG **************/
			eLog.debug(st.toString());
			/***********************************/
			
			int i = st.executeUpdate();
			
			if (i != 1) {
				// ƍڂ̍폜Ɏs܂B
				String errMsg = StringManager.get("E0034");
				throw new DAOException(errMsg);
			}
		} finally {
			st.close();
		}
	}
	
	/**
	 * ʃZbgƍڂ쐬B
	 *
	 * @param rs ʃZbg
	 * @return ƍ
	 * @throws SQLException CӂSQLO
	 */
	private WorkItemBean createBean(ResultSet rs)
	throws SQLException
	{
		WorkItemBean bean = new WorkItemBean();

		bean.setID(rs.getString(WORK_ID));
		bean.setProcessID(rs.getString(PROC_ID));
		bean.setActivityID(rs.getString(ACT_ID));
		bean.setParticipantType(rs.getInt(PARTICIPANT_TYPE));
		bean.setParticipantName(rs.getString(PARTICIPANT_NAME));
		
		return bean;
	}
	
	/**
	 * ʃZbgƍڂ쐬B
	 *
	 * @param rs ʃZbg
	 * @param prefix Ou
	 * @return ƍ
	 * @throws SQLException CӂSQLO
	 */
	private WorkItemBean createBean(ResultSet rs, String prefix)
	throws SQLException
	{
		WorkItemBean bean = new WorkItemBean();

		bean.setID(rs.getString(prefix + WORK_ID));
		bean.setProcessID(rs.getString(prefix + PROC_ID));
		bean.setActivityID(rs.getString(prefix + ACT_ID));
		bean.setParticipantType(rs.getInt(prefix + PARTICIPANT_TYPE));
		bean.setParticipantName(rs.getString(prefix + PARTICIPANT_NAME));
		
		return bean;
	}
}
