/* $Id: ProcessFilterConverter.java,v 1.9 2005/08/26 04:54:36 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.co.argo21.nautica.workflow.filter.FilterConverter;
import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.filter.NameFilter;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;

/**
 * vZXp̃tB^[SQLwhere𐶐Ro[^B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.9 $
 * @since   Nautica Workflow 0.9
 */
public class ProcessFilterConverter implements FilterConverter
{
    /** vZX`ID̃J */
	static public final String PDID = "pdid:";
	
	/**
	 * Ro[^𐶐B
	 *
	 */
	public ProcessFilterConverter() {
	    // ȂB
	}
	
	/**
	 * vZXp̃tB^[SQLwhere𐶐
	 *
	 * @param filter tB^[
	 * @return SQLwhere
	 * @see jp.co.argo21.nautica.workflow.filter.FilterConverter#convertToSQL(jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public String convertToSQL(Filter filter) throws InvalidFilterException
	{
		if (filter == null) {
			return "";
		} else if (filter instanceof NameFilter) {
			return convertToSQL((NameFilter)filter);
		} else if (filter instanceof StateFilter) {
			return convertToSQL((StateFilter)filter);
		} else if (filter instanceof GroupFilter) {
			return convertToSQL((GroupFilter)filter);
		} else {
			// ȃtB^[w肳܂B
			String errMsg = StringManager.get("E0004");
			throw new InvalidFilterException(errMsg);
		}
	}
	
	/**
	 * NameFilterSQLɕϊB
	 *
	 * @param filter NameFilter
	 * @return SQL
	 * @throws InvalidFilterException płȂtB^[̏ꍇ
	 */
	private String convertToSQL(NameFilter filter)
	throws InvalidFilterException
	{
		String fs = filter.getFilterString();
		if (fs != null && fs.startsWith(PDID)) {
			Pattern pattern = Pattern.compile("^" + PDID);
			Matcher matcher = pattern.matcher(fs);

			StringBuffer buffer = new StringBuffer();
			if (matcher.find()) {
				matcher.appendReplacement(buffer , "");
			}
			matcher.appendTail(buffer);
			return MySQLProcessDAO.PROC_DEF_ID
			+ getComparisonString(filter.getComparison())
			+ "'" + buffer + "'";
		} else {
			return MySQLProcessDAO.NAME
			+ getComparisonString(filter.getComparison())
			+ "'" + fs + "'";
		}
	}
	
	/**
	 * StateFilterSQLɕϊB
	 *
	 * @param filter StateFilter
	 * @return SQL
	 * @throws InvalidFilterException płȂtB^[̏ꍇ
	 */
	private String convertToSQL(StateFilter filter)
	throws InvalidFilterException
	{
		return MySQLProcessDAO.PROC_STATE
			+ " = '" +  filter.getFilterString() + "'";
	}
	
	/**
	 * GroupFilterSQLɕϊB
	 *
	 * @param filter GroupFilter
	 * @return SQL
	 * @throws InvalidFilterException płȂtB^[̏ꍇ
	 */
	private String convertToSQL(GroupFilter filter)
	throws InvalidFilterException
	{
		Filter[] children = filter.getChild();
		
		int count = children.length;
		if (count == 0) return "";
		
		String s = convertToSQL(children[0]);
		
		for (int i = 1; i < count; i++) {
			s += " AND " + convertToSQL(children[i]);
		}
		
		return s;
	}
	
	/**
	 * Zq𕶎ɕϊB
	 *
	 * @param comparison Zq
	 * @return 
	 */
	private String getComparisonString(int comparison)
	{
		switch (comparison) {
		case NameFilter.EQUAL:
			return " = ";
		case NameFilter.GREATER_EQUAL:
			return " >= ";
		case NameFilter.GREATER_THAN:
			return " > ";
		case NameFilter.LESS_EQUAL:
			return " <= ";
		case NameFilter.LESS_THAN:
			return " < ";
		case NameFilter.NOT_EQUAL:
			return " <> ";
		case NameFilter.LIKE:
			return " LIKE ";
		default:
			return " <> ";
		}
	}
}
