/* $Id: ActivityDefinition.java,v 1.4 2005/08/26 04:55:41 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition;

import java.util.List;

import org.wfmc.x2002.xpdl10.SubFlowDocument;

/**
 * ANeBreB`pC^tF[X
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public interface ActivityDefinition extends Definition
{
	/** ANeBreBIDpړ */
	static public final String ID_PREFIX       = "AC";
	/** ubNIDpړ */
	static public final String BLOCK_ID_PREFIX = "BK";

	/** ANeBreB^擾L[ */
	static public final String ACTIVITY_TYPE = "ACTIVITY_TYPE";
	/** _XW擾L[ */
	static public final String LOGICAL_X     = "LOGICAL_X";
	/** _YW擾L[ */
	static public final String LOGICAL_Y     = "LOGICAL_Y";
	/** ubNID擾L[ */
	static public final String AFFILIATE_BID = "AFFILIATE_BID";
	/** eubNID擾L[ */
	static public final String PARENT_BID    = "PARENT_BID";
	/** GW */
	static public final String ENGINE_NANE   = "ENGINE_NANE";

	/** JnANeBreB^ */
	static public final String START        = "START";
	/** Θb^ANeBreB^ */
	static public final String INTERACTIVE  = "INTERACTIVE";
	/** sANeBreB^ */
	static public final String AUTOMATIC    = "AUTOMATIC";
	/** TuvZXANeBreB^ */
	static public final String SUBPROCESS   = "SUBPROCESS";
	/** sANeBreB^ */
	static public final String CONCURRENT   = "CONCURRENT";
	/** sJnANeBreB^ */
	static public final String CONCUR_START = "CONCUR_START";
	/** sIANeBreB^ */
	static public final String CONCUR_END   = "CONCUR_END";
	/** IANeBreB^ */
	static public final String END          = "END";

	/** 񓯊 */
	static public final int ASYNCHR = SubFlowDocument.SubFlow.Execution.INT_ASYNCHR;
	/**  */
	static public final int SYNCHR  = SubFlowDocument.SubFlow.Execution.INT_SYNCHR;

	/**
	 * ANeBreB^ԂB
	 * 
	 * @return	ANeBreB^
	 */
	public String getType();

	/**
	 * sԂB
	 * 
	 * @return	s
	 */
	public int getLimit();

	/**
	 * _XWԂB
	 * 
	 * @return	_XW
	 */
	public int getLogicalX();

	/**
	 * _YWԂB
	 * 
	 * @return	_YW
	 */
	public int getLogicalY();

	/**
	 * ubNIDԂB
	 * 
	 * @return	ubNID
	 */
	public String getBlockID();

	/**
	 * ubNIDԂB
	 * 
	 * @return	ubNID
	 */
	public String getAffiliateBID();

	/**
	 * eubNIDԂB
	 * 
	 * @return	eubNID
	 */
	public String getParentBID();

	/**
	 * TuvZXs̓ԂԂB
	 * 
	 * @return	TuvZXs̓
	 */
	public int getExecution();

	/**
	 * AvP[VIDԂB
	 * 
	 * @return	AvP[VID
	 */
	public String getApplicationID();

	/**
	 * TuvZXIDԂB
	 * 
	 * @return	TuvZXID
	 */
	public String getSubprocessID();

	/**
	 * sIDԂB
	 * 
	 * @return	sID
	 */
	public String getPerformerID();

	/**
	 * AvP[Vp[^ꗗԂB
	 * 
	 * @return	AvP[Vp[^ꗗ
	 */
	public List getApplicationParameters();

	/**
	 * TuvZXp[^ꗗԂB
	 * 
	 * @return	TuvZXp[^ꗗ
	 */
	public List getSubprocessParameters();

	/**
	 * GWԂB
	 * 
	 * @return	GW
	 */
	public String getEngineName();
}
