/* $Id: ActivityDefinitionImpl.java,v 1.8 2005/08/26 06:21:09 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import java.util.ArrayList;
import java.util.List;

import org.wfmc.x2002.xpdl10.ActivityDocument;
import org.wfmc.x2002.xpdl10.ActualParametersDocument;
import org.wfmc.x2002.xpdl10.BlockActivityDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributeDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributesDocument;
import org.wfmc.x2002.xpdl10.ImplementationDocument;
import org.wfmc.x2002.xpdl10.SubFlowDocument;
import org.wfmc.x2002.xpdl10.ToolDocument;

import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;

/**
 * ActivityDefinitionC^tF[X̎NXłB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class ActivityDefinitionImpl implements ActivityDefinition
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** ̉ID */
	static private final String UNINITIALIZED_ID = "--UNINITIALIZED--"; 

	/** ID */
	private String id;
	/**  */
	private String name;
	/** l */
	private String description;
	/** s */
	private int limit;
	/** _XW */
	private int logicalX;
	/** _YW */
	private int logicalY;
	/** ubNID */
	private String blockID;
	/** ubNID */
	private String affiliateBID;
	/** eubNID */
	private String parentBID;
	/** AvP[VID */
	private String applicationID;
	/** TuvZXID */
	private String subprocessID;
	/** sID */
	private String performerID;
	/** TuvZXs̓ */
	private int sync;
	/** AvP[Vp[^ꗗ */
	private List applicationParameters = new ArrayList();
	/** TuvZXp[^ꗗ */
	private List subprocessParameters = new ArrayList();
	/** ANeBreB^ */
	private String type;
	/** GW */
	private String engineName;

	/**
	 * ANeBreB𐶐B
	 * 
	 * @param act	XmlObject
	 */
	public ActivityDefinitionImpl(ActivityDocument.Activity act)
	{
		String id = act.getId();
		if (StringUtils.checkNull(id) || id.equals(UNINITIALIZED_ID)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(act.getName());
		setDescription(act.getDescription());

		try {
			setLimit(Integer.parseInt(act.getLimit()));
		} catch (Exception ex) {
			setLimit(0);
		}
	
		if (act.isSetBlockActivity()) {
			BlockActivityDocument.BlockActivity ba = act.getBlockActivity();
			setBlockID(ba.getBlockId());
		}
		
		if (act.isSetPerformer()) {
			setPerformerID(act.getPerformer());
		}
		
		if (act.isSetImplementation()) {
			ImplementationDocument.Implementation imp = act.getImplementation();
			if (imp.isSetSubFlow()) {
				SubFlowDocument.SubFlow sf = imp.getSubFlow();
				setSubprocessID(sf.getId());
				setExecution(sf.getExecution().intValue());
				if (sf.isSetActualParameters()) {
					ActualParametersDocument.ActualParameters aps = sf.getActualParameters();
					int count = aps.sizeOfActualParameterArray();
					for (int i = 0; i < count; i++) {
						String pid = aps.getActualParameterArray(i);
						addSubprocessParameterID(pid);
					}
				}
			}

			if (imp.sizeOfToolArray() == 1) {
				ToolDocument.Tool tool = imp.getToolArray(0);
				setApplicationID(tool.getId());
				if (tool.isSetActualParameters()) {
					ActualParametersDocument.ActualParameters aps = tool.getActualParameters();
					int count = aps.sizeOfActualParameterArray();
					for (int i = 0; i < count; i++) {
						String aid = aps.getActualParameterArray(i);
						addApplicationParameterID(aid);
					}
				}
			}
		}

		if (act.isSetExtendedAttributes()) {
			ExtendedAttributesDocument.ExtendedAttributes eas = act.getExtendedAttributes();
			int count = eas.sizeOfExtendedAttributeArray();
			for (int i = 0; i < count; i++) {
				ExtendedAttributeDocument.ExtendedAttribute ea = eas.getExtendedAttributeArray(i);
				String n = ea.getName();
				String v = ea.getValue();
				if (n.equals(LOGICAL_X)) {
					setLogicalX(Integer.parseInt(v));
				} else if (n.equals(LOGICAL_Y)) {
					setLogicalY(Integer.parseInt(v));
				} else if (n.equals(AFFILIATE_BID)) {
					setAffiliateBID(v);
				} else if (n.equals(PARENT_BID)) {
					setParentBID(v);
				} else if (n.equals(ACTIVITY_TYPE)) {
					setType(v);
				} else if (n.equals(ENGINE_NANE)) {
					setEngineName(v);
				}
			}
		}
	}

	/**
	 * ubNIDԂB
	 * 
	 * @return ubNID
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getBlockID()
	 */
	public String getBlockID()
	{
		return blockID;
	}

	/**
	 * sԂB
	 * 
	 * @return	s
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getLimit()
	 */
	public int getLimit()
	{
		return limit;
	}

	/**
	 * _XWԂB
	 * 
	 * @return _XW
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getLogicalX()
	 */
	public int getLogicalX()
	{
		return logicalX;
	}

	/**
	 * _YWԂB
	 * 
	 * @return _YW
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getLogicalY()
	 */
	public int getLogicalY()
	{
		return logicalY;
	}

	/**
	 * ANeBreB^ԂB
	 * 
	 * @return	ANeBreB^
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getType()
	 */
	public String getType()
	{
		return type;
	}

	/**
	 * ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDԂB
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * ANeBreB̂ԂB
	 * 
	 * @return ANeBreB
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * AvP[VIDԂB
	 * 
	 * @return	AvP[VID
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getApplicationID()
	 */
	public String getApplicationID()
	{
		return applicationID;
	}

	/**
	 * AvP[Vp[^ꗗԂB
	 * 
	 * @return	AvP[Vp[^ꗗ
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getApplicationParameters()
	 */
	public List getApplicationParameters()
	{
		return applicationParameters;
	}

	/**
	 * TuvZXIDԂB
	 * 
	 * @return	TuvZXID
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getSubprocessID()
	 */
	public String getSubprocessID()
	{
		return subprocessID;
	}

	/**
	 * TuvZXp[^ꗗԂB
	 * 
	 * @return	TuvZXp[^ꗗ
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getSubprocessParameters()
	 */
	public List getSubprocessParameters()
	{
		return subprocessParameters;
	}

	/**
	 * TuvZXs̓ԂԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getExecution()
	 */
	public int getExecution()
	{
		return sync;
	}

	/**
	 * ubNIDԂB
	 * 
	 * @return	ubNID
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getAffiliateBID()
	 */
	public String getAffiliateBID()
	{
		return affiliateBID;
	}

	/**
	 * eubNIDԂB
	 * 
	 * @return	eubNID
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getParentBID()
	 */
	public String getParentBID()
	{
		return parentBID;
	}

	/**
	 * sIDԂB
	 * 
	 * @return	sID
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getPerformerID()
	 */
	public String getPerformerID()
	{
		return performerID;
	}

	/**
	 * GWԂB
	 *
	 * @return GW
	 * @see jp.co.argo21.nautica.workflow.definition.ActivityDefinition#getEngineName()
	 */
	public String getEngineName()
	{
		return engineName;
	}

	/**
	 * IDݒ肷B
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * ubNIDݒ肷B
	 * 
	 * @param id ubNID
	 */
	private void setBlockID(String id)
	{
		this.blockID = id;
	}

	/**
	 * sݒ肷BPʂ͏vZXDurationUnitgpB
	 * 
	 * @param limit ҋ@Ԃ̏l
	 */
	private void setLimit(int limit)
	{
		this.limit = limit;
	}

	/**
	 * _XWݒ肷B
	 * 
	 * @param x _XW
	 */
	private void setLogicalX(int x)
	{
		this.logicalX = x;
	}

	/**
	 * _YWݒ肷B
	 * 
	 * @param y _YW
	 */
	private void setLogicalY(int y)
	{
		this.logicalY = y;
	}

	/**
	 * ANeBreB̎ނݒ肷B
	 * 
	 * @param type	ANeBreB̎
	 */
	private void setType(String type)
	{
		this.type = type;
	}

	/**
	 * ݒ肷B
	 * 
	 * @param desc 
	 */
	private void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * ANeBreB̂ݒ肷B
	 * 
	 * @param name ANeBreB
	 */
	private void setName(String name)
	{
		this.name = name;
	}

	/**
	 * AvP[VIDݒ肷B
	 * 
	 * @param id	AvP[VID
	 */
	private void setApplicationID(String id)
	{
		this.applicationID = id;
	}

	/**
	 * TuvZXIDݒ肷B
	 * 
	 * @param id	TuvZXID
	 */
	private void setSubprocessID(String id)
	{
		this.subprocessID = id;
	}

	/**
	 * TuvZXs̓Ԃݒ肷B
	 * 
	 * @param sync 
	 */
	private void setExecution(int sync)
	{
		this.sync = sync;
	}

	/**
	 * ubNIDݒ肷B
	 * 
	 * @param id	ubNID
	 */
	private void setAffiliateBID(String id)
	{
		affiliateBID = id;
	}

	/**
	 * eubNIDݒ肷B
	 * 
	 * @param id	eubNID
	 */
	private void setParentBID(String id)
	{
		parentBID = id;
	}

	/**
	 * sIDݒ肷B
	 * 
	 * @param id	sID
	 */
	private void setPerformerID(String id)
	{
		performerID = id;
	}

	/**
	 * AvP[Vp[^ǉB
	 * 
	 * @param id	AvP[Vp[^
	 */
	private void addApplicationParameterID(String id)
	{
		this.applicationParameters.add(id);
	}

	/**
	 * GWݒ肷B
	 * 
	 * @param engineName GW
	 */
	private void setEngineName(String engineName)
	{
		this.engineName = engineName;
	}

	/**
	 * TuvZXp[^ǉB
	 * 
	 * @param id	TuvZXp[^
	 */
	private void addSubprocessParameterID(String id)
	{
		this.subprocessParameters.add(id);
	}
}
