/* $Id: DefinitionLoader.java,v 1.5 2005/08/26 04:54:31 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.engine.LogManager;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.wfmc.x2002.xpdl10.PackageDocument;

/**
 * XPDL`t@C[_[łB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class DefinitionLoader
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** `t@Czuʒu */
	private String definitionHome;
	
	/**
	 * XPDL`t@C[_[𐶐B
	 *
	 * @param home `t@Czuʒu
	 */
	public DefinitionLoader(String home)
	{
		String separator = System.getProperty("file.separator");

		if (home == null || home.trim().equals("")) {
			definitionHome = "./";
		} else {
			if (home.trim().endsWith(separator) == false) {
				home += separator;
			}
			definitionHome = home;
		}
	}

	/**
	 * [Nt[`hLg[hB
	 * 
	 * @param fn XPDLt@C
	 * @throws XmlException XMLO
	 * @throws IOException o͗O
	 */
	public PackageDefinition load(String fn)
	throws XmlException, IOException
	{
		String fileName = definitionHome + fn;
		InputStream in = new FileInputStream(fileName);
		XmlOptions opts = new XmlOptions();
		opts.setCharacterEncoding("utf-8");

		PackageDocument doc = PackageDocument.Factory.parse(in, opts);
		in.close();
		
		return new PackageDefinitionImpl(doc);
	}
}
