/* $Id: PackageDefinitionImpl.java,v 1.6 2005/08/26 06:21:07 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import java.util.ArrayList;
import java.util.List;

import org.wfmc.x2002.xpdl10.ApplicationDocument;
import org.wfmc.x2002.xpdl10.ApplicationsDocument;
import org.wfmc.x2002.xpdl10.DataFieldDocument;
import org.wfmc.x2002.xpdl10.DataFieldsDocument;
import org.wfmc.x2002.xpdl10.PackageDocument;
import org.wfmc.x2002.xpdl10.PackageHeaderDocument;
import org.wfmc.x2002.xpdl10.ParticipantDocument;
import org.wfmc.x2002.xpdl10.ParticipantsDocument;
import org.wfmc.x2002.xpdl10.RedefinableHeaderDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessesDocument;

import jp.co.argo21.nautica.workflow.definition.ApplicationDefinition;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ParticipantDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.VariableDefinition;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;

/**
 * PackageDefinitionC^tF[X̎NXłB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class PackageDefinitionImpl implements PackageDefinition
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** ̉ID */
	static private final String UNINITIALIZED_ID = "--UNINITIALIZED--"; 

	/** ID */
	private String id;
	/**  */
	private String name;
	/** l */
	private String description;
	/** 쐬 */
	private String createdDate;
	/** o[W */
	private String version;
	/** ` */
	private String author;
	/** [Nt[Q҈ꗗ */
	private List participants = new ArrayList();
	/** AvP[Vꗗ */
	private List applications = new ArrayList();
	/** vZXϐꗗ */
	private List variables = new ArrayList();
	/** vZXꗗ */
	private List processes = new ArrayList();

	/**
	 * pbP[W𐶐B
	 * 
	 * @param doc	XmlObject
	 */
	public PackageDefinitionImpl(PackageDocument doc)
	{
		PackageDocument.Package p = doc.getPackage();
		String id = p.getId();
		if (StringUtils.checkNull(id) || id.equals(UNINITIALIZED_ID)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(p.getName());
		
		PackageHeaderDocument.PackageHeader phd = p.getPackageHeader();
		setDescription(phd.getDescription());
		setCreatedDate(phd.getCreated());
		
		if (p.isSetRedefinableHeader()) {
			RedefinableHeaderDocument.RedefinableHeader rhd
				= p.getRedefinableHeader();
			setAuthor(rhd.getAuthor());
			setVersion(rhd.getVersion());
		}
		
		if (p.isSetApplications()) {
			ApplicationsDocument.Applications apps = p.getApplications();
			int count = apps.sizeOfApplicationArray();
			for (int i = 0; i < count; i++) {
				ApplicationDocument.Application app = apps.getApplicationArray(i);
				ApplicationDefinition e = new ApplicationDefinitionImpl(app);
				addApplication(e);
			}
		}
		
		if (p.isSetParticipants()) {
			ParticipantsDocument.Participants pts = p.getParticipants();
			int count = pts.sizeOfParticipantArray();
			for (int i = 0; i < count; i++) {
				ParticipantDocument.Participant pt = pts.getParticipantArray(i);
				ParticipantDefinition e = new ParticipantDefinitionImpl(pt);
				addParticipant(e);
			}
		}
		
		if (p.isSetDataFields()) {
			DataFieldsDocument.DataFields dfs = p.getDataFields();
			int count = dfs.sizeOfDataFieldArray();
			for (int i = 0; i < count; i++) {
				DataFieldDocument.DataField df = dfs.getDataFieldArray(i);
				VariableDefinition e = new VariableDefinitionImpl(df);
				addVariable(e);
			}
		}
		
		if (p.isSetWorkflowProcesses()) {
			WorkflowProcessesDocument.WorkflowProcesses wps = p.getWorkflowProcesses();
			int count = wps.sizeOfWorkflowProcessArray();
			for (int i = 0; i < count; i++) {
				WorkflowProcessDocument.WorkflowProcess proc = wps.getWorkflowProcessArray(i);
				ProcessDefinition e = new ProcessDefinitionImpl(proc);
				addProcess(e);
			}
		}
	}

	/**
	 * ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDԂB
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * ̂ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * AvP[VꗗԂB
	 * 
	 * @return	AvP[Vꗗ
	 * @see jp.co.argo21.nautica.workflow.definition.PackageDefinition#getApplications()
	 */
	public List getApplications()
	{
		return applications;
	}

	/**
	 * 쐬ԂB
	 * 
	 * @return	쐬
	 * @see jp.co.argo21.nautica.workflow.definition.PackageDefinition#getCreatedDate()
	 */
	public String getCreatedDate()
	{
		return createdDate;
	}

	/**
	 * [Nt[Q҈ꗗԂB
	 * 
	 * @return	[Nt[Q҈ꗗ
	 * @see jp.co.argo21.nautica.workflow.definition.PackageDefinition#getParticipants()
	 */
	public List getParticipants()
	{
		return participants;
	}

	/**
	 * vZXꗗԂB
	 * 
	 * @return	vZXꗗ
	 * @see jp.co.argo21.nautica.workflow.definition.PackageDefinition#getProcesses()
	 */
	public List getProcesses()
	{
		return processes;
	}

	/**
	 * vZXϐꗗԂB
	 * 
	 * @return	vZXϐꗗ
	 * @see jp.co.argo21.nautica.workflow.definition.PackageDefinition#getVariables()
	 */
	public List getVariables()
	{
		return variables;
	}

	/**
	 * o[WԂB
	 * 
	 * @return	o[W
	 * @see jp.co.argo21.nautica.workflow.definition.PackageDefinition#getVersion()
	 */
	public String getVersion()
	{
		return version;
	}

	/**
	 * `҂ԂB
	 * 
	 * @return	`
	 * @see jp.co.argo21.nautica.workflow.definition.PackageDefinition#getAuthor()
	 */
	public String getAuthor()
	{
		return author;
	}

	/**
	 * IDݒ肷B
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * ݒ肷B
	 * 
	 * @param desc 
	 */
	private void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * ̂ݒ肷B
	 * 
	 * @param name 
	 */
	private void setName(String name)
	{
		this.name = name;
	}

	/**
	 * 쐬ݒ肷B
	 * 
	 * @param s 쐬
	 */
	private void setCreatedDate(String s)
	{
		createdDate = s;
	}

	/**
	 * o[Wݒ肷B
	 * 
	 * @param s o[W
	 */
	private void setVersion(String s)
	{
		version = s;
	}

	/**
	 * `҂ݒ肷B
	 * 
	 * @param s `
	 */
	private void setAuthor(String s)
	{
		author = s;
	}

	/**
	 * AvP[VǉB
	 * 
	 * @param app	AvP[V
	 */
	private void addApplication(ApplicationDefinition app)
	{
		this.applications.add(app);
	}

	/**
	 * [Nt[Q҂ǉB
	 * 
	 * @param part	[Nt[Q
	 */
	private void addParticipant(ParticipantDefinition part)
	{
		this.participants.add(part);
	}

	/**
	 * vZXǉB
	 * 
	 * @param proc	vZX
	 */
	private void addProcess(ProcessDefinition proc)
	{
		this.processes.add(proc);
	}

	/**
	 * vZXϐǉB
	 * 
	 * @param var	vZXϐ
	 */
	private void addVariable(VariableDefinition var)
	{
		this.variables.add(var);
	}
}
