/* $Id: ParameterDefinitionImpl.java,v 1.6 2005/08/26 06:21:10 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2002.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import org.wfmc.x2002.xpdl10.BasicTypeDocument;
import org.wfmc.x2002.xpdl10.DataTypeDocument;
import org.wfmc.x2002.xpdl10.FormalParameterDocument;

import jp.co.argo21.nautica.workflow.definition.ParameterDefinition;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;

/**
 * ParameterDefinitionC^tF[X̎NXłB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class ParameterDefinitionImpl implements ParameterDefinition
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** ID */
	private String id;
	/**  */
	private String name;
	/** l */
	private String description;
	/** p[^^ */
	private int type;
	/** o̓[h */
	private int mode;
	
	/**
	 * p[^𐶐B
	 * 
	 * @param pm	XmlObject
	 */
	public ParameterDefinitionImpl(FormalParameterDocument.FormalParameter pm)
	{
		String id = pm.getId();
		if (StringUtils.checkNull(id)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}

		setDescription(pm.getDescription());

		if (pm.isSetMode()) {
			setMode(pm.getMode().intValue());
		}
		
		DataTypeDocument.DataType t = pm.getDataType();
		if (t.isSetBasicType()) {
			BasicTypeDocument.BasicType bt = t.getBasicType();
			BasicTypeDocument.BasicType.Type.Enum type = bt.getType();
			setType(type.intValue());
		}
	}

	/**
	 * ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDԂB
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * ̂ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getName()
	 */
	public String getName()
	{
		return getID();
	}

	/**
	 * o̓[hԂB
	 * 
	 * @return	o̓[h
	 * @see jp.co.argo21.nautica.workflow.definition.ParameterDefinition#getMode()
	 */
	public int getMode()
	{
		return mode;
	}

	/**
	 * p[^^ԂB
	 * 
	 * @return	p[^^
	 * @see jp.co.argo21.nautica.workflow.definition.ParameterDefinition#getType()
	 */
	public int getType()
	{
		return type;
	}

	/**
	 * IDݒ肷B
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * ݒ肷B
	 * 
	 * @param desc 
	 */
	private void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * ̂ݒ肷BÃ\bh͉ȂB
	 * 
	 * @param name 
	 */
	private void setName(String name)
	{
		//NOP
	}

	/**
	 * o̓[hݒ肷B
	 * 
	 * @param i	o̓[h
	 */
	private void setMode(int i)
	{
		mode = i;
	}

	/**
	 * p[^^ݒ肷B
	 * 
	 * @param i	p[^^
	 */
	private void setType(int i)
	{
		type = i;
	}
}
