/* $Id: ProcessDefinitionImpl.java,v 1.7 2005/08/26 06:21:05 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import java.util.ArrayList;
import java.util.List;

import org.wfmc.x2002.xpdl10.ActivitiesDocument;
import org.wfmc.x2002.xpdl10.ActivityDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributeDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributesDocument;
import org.wfmc.x2002.xpdl10.FormalParameterDocument;
import org.wfmc.x2002.xpdl10.FormalParametersDocument;
import org.wfmc.x2002.xpdl10.ProcessHeaderDocument;
import org.wfmc.x2002.xpdl10.RedefinableHeaderDocument;
import org.wfmc.x2002.xpdl10.ResponsiblesDocument;
import org.wfmc.x2002.xpdl10.TransitionDocument;
import org.wfmc.x2002.xpdl10.TransitionsDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessDocument;

import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ParameterDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;

/**
 * ProcessDefinitionC^tF[X̎NXłB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class ProcessDefinitionImpl implements ProcessDefinition
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** ̉ID */
	static private final String UNINITIALIZED_ID = "--UNINITIALIZED--"; 

	/** ID */
	private String id;
	/**  */
	private String name;
	/** l */
	private String description;
	/** ԒP */
	private int durationUnit;
	/** s */
	private int limit;
	/** ANZXx */
	private int accessLevel;
	/** _W */
	private int logicalWidth;
	/** _W */
	private int logicalHeight;
	/** ʒm҈ꗗ */
	private List responsibles = new ArrayList();
	/** p[^ꗗ */
	private List parameters = new ArrayList();
	/** ANeBreBꗗ */
	private List activities = new ArrayList();
	/** Jڈꗗ */
	private List transitions = new ArrayList();

	/**
	 * vZX𐶐B
	 * 
	 * @param proc	XmlObject
	 */
	public ProcessDefinitionImpl(WorkflowProcessDocument.WorkflowProcess proc)
	{
		String id = proc.getId();
		if (StringUtils.checkNull(id) || id.equals(UNINITIALIZED_ID)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(proc.getName());
		
		ProcessHeaderDocument.ProcessHeader ph = proc.getProcessHeader();
		setDescription(ph.getDescription());
		setDurationUnit(ph.getDurationUnit().intValue());
		try {
			setLimit(Integer.parseInt(ph.getLimit()));
		} catch (Exception ex) {
			setLimit(0);
		}
		setAccessLevel(proc.getAccessLevel().intValue());

		if (proc.isSetRedefinableHeader()) {
			RedefinableHeaderDocument.RedefinableHeader rhd
				= proc.getRedefinableHeader();
			if (rhd.isSetResponsibles()) {
				ResponsiblesDocument.Responsibles rsps = rhd.getResponsibles();
				int count = rsps.sizeOfResponsibleArray();
				for (int i = 0; i < count; i++) {
					String rsp = rsps.getResponsibleArray(i);
					addResponsible(rsp);
				}
			}
		}

		if (proc.isSetExtendedAttributes()) {
			ExtendedAttributesDocument.ExtendedAttributes eas = proc.getExtendedAttributes();
			int count = eas.sizeOfExtendedAttributeArray();
			for (int i = 0; i < count; i++) {
				ExtendedAttributeDocument.ExtendedAttribute ea = eas.getExtendedAttributeArray(i);
				String n = ea.getName();
				String v = ea.getValue();
				if (n.equals(LOGICAL_WIDTH)) {
					setLogicalWidth(Integer.parseInt(v));
				} else if (n.equals(LOGICAL_HEIGHT)) {
					setLogicalHeight(Integer.parseInt(v));
				}
			}
		}
		
		if (proc.isSetFormalParameters()) {
			FormalParametersDocument.FormalParameters pms = proc.getFormalParameters();
			int count = pms.sizeOfFormalParameterArray();
			for (int i = 0; i < count; i++) {
				FormalParameterDocument.FormalParameter pm = pms.getFormalParameterArray(i);
				ParameterDefinition e = new ParameterDefinitionImpl(pm);
				addParameter(e);
			}
		}
		
		if (proc.isSetActivities()) {
			ActivitiesDocument.Activities acts = proc.getActivities();
			int count = acts.sizeOfActivityArray();
			for (int i = 0; i < count; i++) {
				ActivityDocument.Activity act = acts.getActivityArray(i);
				ActivityDefinition e = new ActivityDefinitionImpl(act);
				addActivity(e);
			}
		}
		
		if (proc.isSetTransitions()) {
			TransitionsDocument.Transitions trs = proc.getTransitions();
			int count = trs.sizeOfTransitionArray();
			for (int i = 0; i < count; i++) {
				TransitionDocument.Transition tr = trs.getTransitionArray(i);
				TransitionDefinition e = new TransitionDefinitionImpl(tr, getActivities());
				addTransition(e);
			}
		}
	}

	/**
	 * ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDԂB
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * ̂ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * ANeBreBꗗԂB
	 * 
	 * @return	ANeBreBꗗ
	 * @see jp.co.argo21.nautica.workflow.definition.ProcessDefinition#getActivities()
	 */
	public List getActivities() {
		return activities;
	}

	/**
	 * ԒPʂԂB
	 * 
	 * @return	ԒP
	 * @see jp.co.argo21.nautica.workflow.definition.ProcessDefinition#getDurationUnit()
	 */
	public int getDurationUnit()
	{
		return durationUnit;
	}

	/**
	 * sԂB
	 * 
	 * @return	s
	 * @see jp.co.argo21.nautica.workflow.definition.ProcessDefinition#getLimit()
	 */
	public int getLimit()
	{
		return limit;
	}

	/**
	 * _WԂB
	 * 
	 * @return	_W
	 * @see jp.co.argo21.nautica.workflow.definition.ProcessDefinition#getLogicalHeight()
	 */
	public int getLogicalHeight()
	{
		return logicalHeight;
	}

	/**
	 * _WԂB
	 * 
	 * @return	_W
	 * @see jp.co.argo21.nautica.workflow.definition.ProcessDefinition#getLogicalWidth()
	 */
	public int getLogicalWidth()
	{
		return logicalWidth;
	}

	/**
	 * p[^ꗗԂB
	 * 
	 * @return	p[^ꗗ
	 * @see jp.co.argo21.nautica.workflow.definition.ProcessDefinition#getParameters()
	 */
	public List getParameters()
	{
		return parameters;
	}

	/**
	 * JڈꗗԂB
	 * 
	 * @return	Jڈꗗ
	 * @see jp.co.argo21.nautica.workflow.definition.ProcessDefinition#getTransitions()
	 */
	public List getTransitions()
	{
		return transitions;
	}

	/**
	 * ʒm҈ꗗԂB
	 * 
	 * @return	ʒm҈ꗗ
	 * @see jp.co.argo21.nautica.workflow.definition.ProcessDefinition#getResponsibles()
	 */
	public List getResponsibles()
	{
		return responsibles;
	}

	/**
	 * ANZXxԂB
	 * 
	 * @return	ANZXx
	 */
	public int getAccessLevel()
	{
		return accessLevel;
	}

	/**
	 * IDݒ肷B
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * ANZXxݒ肷B
	 * 
	 * @param i	ANZXx
	 */
	private void setAccessLevel(int i)
	{
		accessLevel = i;
	}

	/**
	 * ݒ肷B
	 * 
	 * @param desc 
	 */
	private void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * ̂ݒ肷B
	 * 
	 * @param name 
	 */
	private void setName(String name)
	{
		this.name = name;
	}

	/**
	 * ԒPʂݒ肷B
	 * 
	 * @param i	ԒP
	 */
	private void setDurationUnit(int i)
	{
		durationUnit = i;
	}

	/**
	 * sݒ肷B
	 * 
	 * @param i	s
	 */
	private void setLimit(int i)
	{
		limit = i;
	}

	/**
	 * _Wݒ肷B
	 * 
	 * @param i	_W
	 */
	private void setLogicalHeight(int i)
	{
		logicalHeight = i;
	}

	/**
	 * _Wݒ肷B
	 * 
	 * @param i	_W
	 */
	private void setLogicalWidth(int i)
	{
		logicalWidth = i;
	}

	/**
	 * ANeBreBǉB
	 * 
	 * @param act	ANeBreB
	 */
	private void addActivity(ActivityDefinition act)
	{
		this.activities.add(act);
	}

	/**
	 * p[^ǉB
	 * 
	 * @param param	p[^
	 */
	private void addParameter(ParameterDefinition param)
	{
		this.parameters.add(param);
	}

	/**
	 * ʒm҂ǉB
	 * 
	 * @param r	ʒm
	 */
	private void addResponsible(String r)
	{
		this.responsibles.add(r);
	}

	/**
	 * JڂǉB
	 * 
	 * @param tr	J
	 */
	private void addTransition(TransitionDefinition tr)
	{
		this.transitions.add(tr);
	}
}
