/* $Id: TransitionDefinitionImpl.java,v 1.8 2005/08/26 06:21:08 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2002.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import java.util.Iterator;
import java.util.List;

import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.expression.ExceptionExpression;
import jp.co.argo21.nautica.workflow.expression.Expression;
import jp.co.argo21.nautica.workflow.expression.LogicalExpression;
import jp.co.argo21.nautica.workflow.expression.OtherwiseExpression;
import jp.co.argo21.nautica.workflow.expression.RelationalExpression;
import jp.co.argo21.nautica.workflow.expression.UnaryExpression;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;
import jp.co.argo21.nautica.workflow.xpdl.ConditionalExpressionDocument;

import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.wfmc.x2002.xpdl10.ConditionDocument;
import org.wfmc.x2002.xpdl10.TransitionDocument;

/**
 * TransitionDefinitionC^tF[X̎NXłB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class TransitionDefinitionImpl implements TransitionDefinition
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** ID */
	private String id;
	/**  */
	private String name;
	/** l */
	private String description;
	/** JڌANeBreB */
	private ActivityDefinition source;
	/** JڐANeBreB */
	private ActivityDefinition destination;
	/** Jڏ */
	private Expression condition;
	/** Jڌ^ */
	private int type;

	/**
	 * Jڂ𐶐B
	 * 
	 * @param tr	XmlObject
	 * @param acts	ANeBreBꗗ
	 */
	public TransitionDefinitionImpl(TransitionDocument.Transition tr, List acts)
	{
		String id = tr.getId();
		if (StringUtils.checkNull(id)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(tr.getName());
		setDescription(tr.getDescription());
		
		String sid = tr.getFrom();
		setSource(getActivityDefinition(acts, sid));
		
		String did = tr.getTo();
		setDestination(getActivityDefinition(acts, did));
		
		if (tr.isSetCondition()) {
			ConditionDocument.Condition c = tr.getCondition();
			int type = c.getType().intValue();
			try {
				if (type == CONDITION) {
					XmlObject obj = XmlObject.Factory.parse(c.toString());
					//lݒ肳Ăꍇ̂ConditionalExpressionDocument^
					//IuWFNgԂĂB
					if (obj == null) {
						setCondition(null);
					} else if (obj instanceof ConditionalExpressionDocument) {
						ConditionalExpressionDocument ceDoc
							= (ConditionalExpressionDocument)obj;
						ConditionalExpressionDocument.ConditionalExpression ce
							= ceDoc.getConditionalExpression();
						if (ce.isSetRelationalExpression()) {
							setCondition(new RelationalExpression(ce.getRelationalExpression()));
						} else if (ce.isSetUnaryExpression()) {
							setCondition(new UnaryExpression(ce.getUnaryExpression()));
						} else if (ce.isSetLogicalExpression()) {
							setCondition(new LogicalExpression(ce.getLogicalExpression()));
						}
					} else {
						setCondition(null);
					}
				} else if (type == OTHERWISE) {
					setCondition(new OtherwiseExpression());
				} else if (type == EXCEPTION) {
					setCondition(new ExceptionExpression());
				}
			} catch (XmlException ex) {
				//NOP
			}
		} else {
			setCondition(null);
		}
	}

	/**
	 * ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDԂB
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * ̂ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * JڏԂB
	 * 
	 * @return	Jڏ
	 * @see jp.co.argo21.nautica.workflow.definition.TransitionDefinition#getCondition()
	 */
	public Expression getCondition()
	{
		return condition;
	}

	/**
	 * JڐANeBreBԂB
	 * 
	 * @return	JڐANeBreB
	 * @see jp.co.argo21.nautica.workflow.definition.TransitionDefinition#getDestination()
	 */
	public ActivityDefinition getDestination()
	{
		return destination;
	}

	/**
	 * JڌANeBreBԂB
	 * 
	 * @return	JڌANeBreB
	 * @see jp.co.argo21.nautica.workflow.definition.TransitionDefinition#getSource()
	 */
	public ActivityDefinition getSource()
	{
		return source;
	}

	/**
	 * Jڌ^ԂB
	 * 
	 * @return	Jڌ^
	 * @see jp.co.argo21.nautica.workflow.definition.TransitionDefinition#getType()
	 */
	public int getType()
	{
		return type;
	}

	/**
	 * IDݒ肷B
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * JڌANeBreBݒ肷B
	 * 
	 * @param act	JڌANeBreB
	 */
	private void setSource(ActivityDefinition act)
	{
		this.source = act;
	}

	/**
	 * JڐANeBreBݒ肷B
	 * 
	 * @param act	JڐANeBreB
	 */
	private void setDestination(ActivityDefinition act)
	{
		this.destination = act;
	}

	/**
	 * ݒ肷B
	 * 
	 * @param desc 
	 */
	private void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * ̂ݒ肷B
	 * 
	 * @param name 
	 */
	private void setName(String name)
	{
		this.name = name;
	}

	/**
	 * Jڏݒ肷B
	 * 
	 * @param cond	Jڏ
	 */
	private void setCondition(Expression cond)
	{
		if (cond == null) {
			type = CONDITION;
		} else if (cond instanceof OtherwiseExpression) {
			type = OTHERWISE;
		} else if (cond instanceof ExceptionExpression) {
			type = EXCEPTION;
		} else {
			type = CONDITION;
		}
		condition = cond;
	}

	/**
	 * Jڌ^ݒ肷B
	 * 
	 * @param i	Jڌ^
	 */
	private void setType(int i)
	{
		type = i;
	}

	/**
	 * w肳ꂽIDANeBreBԂB
	 * 
	 * @param acts	ANeBreBꗗ
	 * @param id	ANeBreBID
	 * @return	ANeBreB
	 */
	private ActivityDefinition getActivityDefinition(List acts, String id)
	{
		Iterator it = acts.iterator();
		while (it.hasNext()) {
			ActivityDefinition act = (ActivityDefinition)it.next();
			String aid = act.getID();
			if (id.equals(aid)) return act;
		}
		return null;
	}
}
