/* $Id: VariableDefinitionImpl.java,v 1.7 2005/08/26 06:21:09 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import org.wfmc.x2002.xpdl10.BasicTypeDocument;
import org.wfmc.x2002.xpdl10.DataFieldDocument;
import org.wfmc.x2002.xpdl10.DataTypeDocument;

import jp.co.argo21.nautica.workflow.definition.VariableDefinition;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;

/**
 * VariableDefinitionC^tF[X̎NXłB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class VariableDefinitionImpl implements VariableDefinition
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** ID */
	private String id;
	/**  */
	private String name;
	/** l */
	private String description;
	/** ^ */
	private int type;
	/** l */
	private String initialValue;
	/** ς݃tO */
	private boolean isInitialized;

	/**
	 * vZXϐ𐶐B
	 * 
	 * @param df	XmlObject
	 */
	public VariableDefinitionImpl(DataFieldDocument.DataField df)
	{
		String id = df.getId();
		if (StringUtils.checkNull(id)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(df.getName());
		setDescription(df.getDescription());
		setInitialValue(df.getInitialValue());
		
		DataTypeDocument.DataType t = df.getDataType();
		if (t != null && t.isSetBasicType()) {
			BasicTypeDocument.BasicType bt = t.getBasicType();
			BasicTypeDocument.BasicType.Type.Enum type = bt.getType();
			setType(type.intValue());
			isInitialized = true;
		} else {
			setType(STRING);
			isInitialized = false;
		}
	}

	/**
	/**
	 * ς݂ǂԂB
	 * 
	 * @return	ς݂Ȃtrue
	 * @see jp.co.argo21.nautica.workflow.definition.VariableDefinition#isInitialized()
	 */
	public boolean isInitialized()
	{
		return isInitialized;
	}

	/**
	 * ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDԂB
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * ̂ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * lԂB
	 * 
	 * @return	l
	 * @see jp.co.argo21.nautica.workflow.definition.VariableDefinition#getInitialValue()
	 */
	public String getInitialValue()
	{
		return initialValue;
	}

	/**
	 * ^ԂB
	 * 
	 * @return	^
	 * @see jp.co.argo21.nautica.workflow.definition.VariableDefinition#getType()
	 */
	public int getType()
	{
		return type;
	}

	/**
	 * IDݒ肷B
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * ݒ肷B
	 * 
	 * @param desc 
	 */
	private void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * ̂ݒ肷B
	 * 
	 * @param name 
	 */
	private void setName(String name)
	{
		this.name = name;
	}

	/**
	 * lݒ肷B
	 * 
	 * @param v	l
	 */
	private void setInitialValue(String v)
	{
		initialValue = v;
	}

	/**
	 * ^ݒ肷B
	 * 
	 * @param i	^
	 */
	private void setType(int i)
	{
		type = i;
		isInitialized = true;
	}
}
