/* $Id: AbstractActivityBehavior.java,v 1.12 2005/08/26 04:53:04 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ApplicationDefinition;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ParticipantDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.definition.VariableDefinition;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.util.DurationHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;

/**
 * ANeBreB̏ԂƂ̓`邽߂̒ۊNXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.12 $
 * @since   Nautica Workflow 0.9
 */
public abstract class AbstractActivityBehavior implements ActivityBehavior
{
	/** GWO */
	static protected Logger eLog = LogManager.getEngineLogger();

	/**
	 * ۃANeBreB𐶐B
	 */
	public AbstractActivityBehavior()
	{
	}

	/**
	 * sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#complete(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal)
	 */
	public void complete(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		ProcessBean pbean = proc.getBean();
		String pid = pbean.getID();
		ActivityBean abean = act.getBean();
		String bid = abean.getBlockID();

		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		VariableDAO varDAO = daoFactory.getVariableDAO();
		List vars = varDAO.findByProcessIDAsList(pid);
		List trs = ConditionEvaluator.evaluate(pd, ad, vars, false);
		
		Iterator it = trs.iterator();
		List acts = new ArrayList();
		while (it.hasNext()) {
			TransitionDefinition tr = (TransitionDefinition)it.next();
			ActivityDefinition dest = tr.getDestination();
			
			//JڐANeBreB̐
			ActivityBean ab = createActivity(pd, dest, pbean, bid);
			acts.add(ab);
		}
		
		if (acts.size() == 0) {
			//Jڐ悪ȂB`~X̉\B
			suspend(pd, ad, proc, act);
			String F0001 = StringManager.get("F0001");
			eLog.fatal(F0001);
			return;
		}
		
		//YANeBreBB
		//ANeBreB̏ԂCLOSED_COMPLETED̏ԂɂB
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.CLOSED_COMPLETED, ts);
		
			
		//JڐANeBreBbZ[WL[ɓo^B
		Iterator ait = acts.iterator();
		while (ait.hasNext()) {
			ActivityBean ab = (ActivityBean)ait.next();
			WorkflowEngine engine = WorkflowEngine.getInstance();
			String aid = ab.getActivityID();
			WorkflowMessage sarmsg = new StartActivityRequestMessage(pid, aid);
			SystemMessageTransporter mt = new SystemMessageTransporter(StartActivityRequestWatcher.NAME);
			mt.sendMessage(sarmsg);
		}
	}


	/**
	 * ۗsB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#suspend(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal)
	 */
	public void suspend(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		//YANeBreBꎞ~B
		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.OPEN_NOT_RUNNING_SUSPENDED, ts);
	}

	/**
	 * AsB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#resume(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal)
	 */
	public void resume(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		//YANeBreB𕜋AB
		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.OPEN_RUNNING, ts);
	}

	/**
	 * Ɏw肳ꂽ񂩂VKANeBreBCX^X𐶐B
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param pbean vZX
	 * @param bid ubNID
	 * @return VKɍꂽANeBreB
	 * @throws Exception
	 */
	protected ActivityBean createActivity(
			ProcessDefinition pd, ActivityDefinition ad, ProcessBean pbean, String bid)
	throws Exception
	{
		//C[̃ANeBreB̏ꍇ
		if (! (bid == null || bid.trim().equals(""))) {
			String type = ad.getType();
			if (type.equals(ActivityDefinition.CONCUR_END)) {
				ActivityBean ceabean = getConcurrentEndActivity(pd, ad, pbean, bid);
				//łɕʂȑJڂɂĊYIANeBreBĂꍇ
				//ԂB
				if (ceabean != null) {
					return ceabean;
				}
			}
		}
		
		Timestamp ts = DataAccessManager.getAccessTime();
		int du = pd.getDurationUnit();
		int limit = ad.getLimit();
		long durationLimit = ts.getTime() + DurationHelper.calculateDuration(du, limit);
		Timestamp limitTs = new Timestamp(durationLimit);
		
		ActivityBean abean = new ActivityBean();
		abean.setActivityDefinitionID(ad.getID());
		abean.setActivityID(UniqueKeyGenerator.generate(ActivityBean.ID_PREFIX));
		abean.setActivityState(ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.toInt());
		abean.setActorID(ParticipantImpl.SYSTEM_ID);
		abean.setDurationLimit(limitTs);
		abean.setProcessID(pbean.getID());
		abean.setStartDate(ts);
		abean.setStarterID(pbean.getStarterID());
		abean.setUpdateDate(ts);
		abean.setBlockID(bid);
		
		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		actDAO.insert(abean);
		
		return abean;
	}
	
	/**
	 * œ肳郏[Nt[QҒ`ԂB
	 *
	 * @param pdid vZX`ID
	 * @param performerID [Nt[QҒ`ID
	 * @return [Nt[QҒ`
	 * @throws Exception Cӂ̗O
	 */
	protected ParticipantDefinition getParticipantDefinition(
			String pdid, String performerID)
	throws Exception
	{
		WorkflowEngine engine = WorkflowEngine.getInstance();
		DefinitionRepositoryImpl dr = engine.getDefinitionRepository();
		PackageDefinition pkgd = dr.getPackageDefinition(pdid);
		List parts = pkgd.getParticipants();
		Iterator it = parts.iterator();
		ParticipantDefinition partd = null;
		while (it.hasNext()) {
			ParticipantDefinition def = (ParticipantDefinition)it.next();
			if (def.getID().equals(performerID)) {
				partd = def;
				break;
			}
		}
		return partd;
	}
	
	/**
	 * œ肳AvP[V`ԂB
	 *
	 * @param pdid vZX`ID
	 * @param appID AvP[V`ID
	 * @return AvP[V`
	 * @throws Exception Cӂ̗O
	 */
	protected ApplicationDefinition getApplicationDefinition(
			String pdid, String appID)
	throws Exception
	{
		WorkflowEngine engine = WorkflowEngine.getInstance();
		DefinitionRepositoryImpl dr = engine.getDefinitionRepository();
		PackageDefinition pkgd = dr.getPackageDefinition(pdid);
		List apps = pkgd.getApplications();
		Iterator it = apps.iterator();
		ApplicationDefinition appd = null;
		while (it.hasNext()) {
			ApplicationDefinition def = (ApplicationDefinition)it.next();
			if (def.getID().equals(appID)) {
				appd = def;
				break;
			}
		}
		return appd;
	}
	
	/**
	 * œ肳vZXϐ`ԂB
	 *
	 * @param pdid vZX`ID
	 * @param varID vZXϐ`ID
	 * @return vZXϐ`
	 * @throws Exception Cӂ̗O
	 */
	protected VariableDefinition getVariableDefinition(
			String pdid, String varID)
	throws Exception
	{
		WorkflowEngine engine = WorkflowEngine.getInstance();
		DefinitionRepositoryImpl dr = engine.getDefinitionRepository();
		PackageDefinition pkgd = dr.getPackageDefinition(pdid);
		List vars = pkgd.getVariables();
		Iterator it = vars.iterator();
		VariableDefinition vard = null;
		while (it.hasNext()) {
			VariableDefinition def = (VariableDefinition)it.next();
			if (def.getID().equals(varID)) {
				vard = def;
				break;
			}
		}
		return vard;
	}

	/**
	 * Ɏw肳ꂽ񂩂瓯IANeBreBCX^XB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param pbean vZX
	 * @param bid ubNID
	 * @return VKɍꂽANeBreB
	 * @throws Exception
	 */
	private ActivityBean getConcurrentEndActivity(
			ProcessDefinition pd, ActivityDefinition ad, ProcessBean pbean, String bid)
	throws Exception
	{
		String pid = pbean.getID();
		String adid = ad.getID();
		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		ActivityBean abean = actDAO.findConcurrentEnd(pid, adid, bid);
		
		return abean;
	}
}
