/* $Id: ActivityBehavior.java,v 1.6 2005/08/26 04:53:34 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;

/**
 * ANeBreB̏ԂƂ̓`C^tF[XłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public interface ActivityBehavior
{
	/**
	 * JnsB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	public void start(
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception;
	
	/**
	 * ۗsB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	public void suspend(
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception;
	
	/**
	 * ĊJsB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @throws Exception
	 */
	public void resume(
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception;
	
	/**
	 * sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	public void complete(
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception;

	/**
	 * ~sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	public void abort(
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, boolean checkChild)
	throws Exception;
	
	/**
	 * ~sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	public void terminate(
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, boolean checkChild)
	throws Exception;
}
