/* $Id: ActivityBehaviorFactory.java,v 1.5 2005/08/26 04:53:17 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.Hashtable;
import java.util.Map;

import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;

import org.apache.log4j.Logger;

/**
 * ANeBreB̃t@NgłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
class ActivityBehaviorFactory
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** ActivityBehaviorFactorỹVOg */
	static private ActivityBehaviorFactory singleton;

	/** ANeBreBpnbVe[u */
	private Map activityBehaviors = new Hashtable();
	
	/**
	 * ActivityBehaviorFactory̐ƏsB
	 *
	 * @throws Exception Cӂ̗O
	 */
	static void create() throws Exception
	{
		singleton = new ActivityBehaviorFactory();
		try {
			singleton.init();
		} catch (Exception ex) {
			// ANeBreB̃t@Ng̐Ɏs܂B
			String msg = StringManager.get("E0051");
			eLog.error(msg);
			throw new WorkflowException(msg);
		}
	}

	/**
	 * ActivityBehaviorFactorỹCX^XԂB
	 *
	 * @return ActivityBehaviorFactory
	 */
	static ActivityBehaviorFactory getInstance()
	{
		return singleton;
	}
	
	/**
	 * ActivityBehaviorFactory𐶐B
	 */
	private ActivityBehaviorFactory()
	{
	}
	
	/**
	 * ActivityBehaviorFactoryB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void init() throws Exception
	{
		activityBehaviors.put(ActivityDefinition.START, new StartActivityBehavior());
		activityBehaviors.put(ActivityDefinition.INTERACTIVE, new InteractiveActivityBehavior());
		activityBehaviors.put(ActivityDefinition.AUTOMATIC, new AutomaticActivityBehavior());
		activityBehaviors.put(ActivityDefinition.SUBPROCESS, new SubprocessActivityBehavior());
		activityBehaviors.put(ActivityDefinition.CONCUR_START, new ConcurrentStartActivityBehavior());
		activityBehaviors.put(ActivityDefinition.CONCUR_END, new ConcurrentEndActivityBehavior());
		activityBehaviors.put(ActivityDefinition.END, new EndActivityBehavior());
	}

	/**
	 * w肳ꂽ^ɑΉANeBreBԂB
	 *
	 * @param type ANeBreB̌^
	 * @return ANeBreB
	 */
	public ActivityBehavior getActivityBehavior(String type)
	{
		return (ActivityBehavior)activityBehaviors.get(type);
	}
}
