/* $Id: ActivityInternal.java,v 1.29 2005/08/29 08:29:30 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemBean;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.dataaccess.mysql.VariableFilterConverter;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.omg.AlreadyRunningException;
import jp.co.argo21.nautica.workflow.omg.AlreadySuspendedException;
import jp.co.argo21.nautica.workflow.omg.CannotCompleteException;
import jp.co.argo21.nautica.workflow.omg.CannotResumeException;
import jp.co.argo21.nautica.workflow.omg.CannotStartException;
import jp.co.argo21.nautica.workflow.omg.CannotStopException;
import jp.co.argo21.nautica.workflow.omg.CannotSuspendException;
import jp.co.argo21.nautica.workflow.omg.HistoryNotAvailableException;
import jp.co.argo21.nautica.workflow.omg.InvalidDataException;
import jp.co.argo21.nautica.workflow.omg.InvalidPerformerException;
import jp.co.argo21.nautica.workflow.omg.InvalidStateException;
import jp.co.argo21.nautica.workflow.omg.NotRunningException;
import jp.co.argo21.nautica.workflow.omg.NotSuspendedException;
import jp.co.argo21.nautica.workflow.omg.ResultNotAvailableException;
import jp.co.argo21.nautica.workflow.omg.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.omg.UpdateNotAllowedException;
import jp.co.argo21.nautica.workflow.omg.WfActivity;
import jp.co.argo21.nautica.workflow.omg.WfAssignment;
import jp.co.argo21.nautica.workflow.omg.WfEvent;
import jp.co.argo21.nautica.workflow.omg.WfNameValue;
import jp.co.argo21.nautica.workflow.omg.WfProcess;
import jp.co.argo21.nautica.workflow.omg.WfProcessManager;
import jp.co.argo21.nautica.workflow.omg.WfResource;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.ParticipantHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.Participant;

/**
 * GWŎgpANeBreB\B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.29 $
 * @since   Nautica Workflow 0.9
 */
public class ActivityInternal implements WfActivity
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	private Activity activity;
	

	/**
	 * pANeBreB𐶐B
	 *
	 * @param act ANeBreB
	 */
	ActivityInternal(Activity act)
	{
		this.activity = act;
	}

	/**
	 * ̃ANeBreBĂWfProcessԂB
	 *
	 * @return WfProcess
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfActivity#getContainer()
	 */
	public WfProcess getContainer() throws WorkflowException
	{
		String pid = activity.getProcessID();
		ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
		WfProcessManager pm = pmf.getOwnerProcessManager(pid);
		WfProcess process = pm.getProcess(pid);
		return process;
	}

	/**
	 * IDԂB
	 *
	 * @return ID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getID()
	 */
	public String getID() throws WorkflowException
	{
		return activity.getActivityID();
	}

	/**
	 * ̂ԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getName()
	 */
	public String getName() throws WorkflowException
	{
		return activity.getName();
	}

	/**
	 * ̂ݒ肷B
	 *
	 * @param name 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#setName(java.lang.String)
	 */
	public void setName(String name) throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * ڍ׏ԂB
	 *
	 * @return ڍ׏
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getDescription()
	 */
	public String getDescription() throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * ݂̏ԂԂB
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getState()
	 */
	public WfState getState() throws WorkflowException
	{
		return ActivityState.getState(activity.getActivityState());
	}

	/**
	 * ݂̏ԂJډ\ȏԂ̈ꗗԂB
	 *
	 * @return Jډ\ȏԂ̈ꗗ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getTransitableStates()
	 */
	public WfState[] getTransitableStates() throws WorkflowException
	{
		return ActivityState.getTransitableStates(activity.getActivityState());
	}

	/**
	 * ŌɏԂJڂԂԂB
	 *
	 * @return ŏIԕύX
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getLastStateTime()
	 */
	public String getLastStateTime() throws WorkflowException
	{
		return activity.getUpdateDate().toString();
	}

	/**
	 * NGX^Ɋ֘A郊\[XԂB
	 *
	 * @return NGX^̎̂ƂȂ\[X
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfRequester#getReqesterResource()
	 */
	public WfResource getReqesterResource() throws WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			WorkItemDAO workitemDAO = daoFactory.getWorkItemDAO();
			
			WorkItemBean workitem = workitemDAO.findByProcessIDANDActivityID(activity.getProcessID(), activity.getActivityID());
			Participant part = null;
			if (workitem == null) {
				//Ήƍڂ݂Ȃ
				part = ParticipantImpl.getSystemParticipant();
			} else {
				int ptype = workitem.getParticipantType();
				String pname =workitem.getParticipantName();
				ResourceManagerFactory rmf = ResourceManagerFactory.getInstance();
				if (ptype == Participant.HUMAN) {
					UserManager um = rmf.getUserManager();
					User user = um.getUser(pname);
					part = ParticipantHelper.narrow(user);
				} else if (ptype == Participant.ORGANIZATIONAL_UNIT) {
					OrganizationManager om = rmf.getOrganizationManager();
					Organization org = om.getOrganization(pname);
					part = ParticipantHelper.narrow(org);
				} else if (ptype == Participant.ROLE) {
					RoleManager rm = rmf.getRoleManager();
					Role role = rm.getRole(pname);
					part = ParticipantHelper.narrow(role);
				} else {
					// FȂ\[X^łB
					String E0073 = StringManager.get("E0073");
					throw new WorkflowException(E0073);
				}
			}
			if (part == null) {
				// [Nt[Qҏ񂪎擾ł܂łB
				String E0074 = StringManager.get("E0074");
				throw new WorkflowException(E0074);
			}
			WfResource ret = new ResourceInternal(part);
			return ret;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ֘A郊\[X̎擾Ɏs܂B
			String E0075 = StringManager.get("E0075");
			throw new WorkflowException(E0075, ex);
		}
	}

	/**
	 * sIuWFNgɂ鑮ꗗԂB
	 *
	 * @return ꗗ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getContext()
	 */
	public WfNameValue[] getContext() throws WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			VariableDAO variableDAO = daoFactory.getVariableDAO();
			
			VariableBean[] beans = variableDAO.findByProcessID(activity.getProcessID());
			
			return beans;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ֘AvZXϐ̎擾Ɏs܂B
			String E0076 = StringManager.get("E0076");
			throw new WorkflowException(E0076, ex);
		}
	}

	/**
	 * sIuWFNgɂ鑮ԂB
	 *
	 * @param name 
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getContext()
	 */
	public WfNameValue getContext(String name) throws WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			VariableDAO variableDAO = daoFactory.getVariableDAO();
			
			VariableBean beans = variableDAO.findByName(activity.getProcessID(), name);
		
			return beans;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ֘AvZXϐ̎擾Ɏs܂B
			String E0076 = StringManager.get("E0076") + "(" + name + ")";
			throw new WorkflowException(E0076, ex);
		}
	}

	/**
	 * WfActivityɂĕ\Ƃ̎sɂĐ錋ʂԂB
	 * ʃf[^܂p\łȂꍇ́AOB
	 *
	 * @return@sʂԂ
	 * @throws ResultNotAvailableException ʂȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfActivity#getResult()
	 */
	public WfNameValue[] getResult()
	throws ResultNotAvailableException, WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * 蓖ĂĂ邷ׂẴATCgԂB
	 *
	 * @return WfAssignment
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfActivity#getAllAssignment()
	 */
	public WfAssignment[] getAllAssignment() throws WorkflowException
	{
		try {
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			WorkItemDAO workitemDAO = daoFactory.getWorkItemDAO();
			
			WorkItemBean workitem = workitemDAO.findByProcessIDANDActivityID(activity.getProcessID(), activity.getActivityID());
			WorkItemInternal[] ret = null;
			if (workitem == null) {
				ret = new WorkItemInternal[0];
			} else {
				ret = new WorkItemInternal[1];
				ret[0] = new WorkItemInternal(workitem);
			}
			return ret;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ֘Aƍڂ̎擾Ɏs܂B
			String E0077 = StringManager.get("E0077");
			throw new WorkflowException(E0077, ex);
		}
	}

	/**
	 * CfNXŎw肳ꂽATCgԂB
	 *
	 * @param index CfNX
	 * @return WfAssignment
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfActivity#getAssignment(int)
	 */
	public WfAssignment getAssignment(int index) throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * 蓖ĂĂATCǧԂB
	 *
	 * @return WfAssignmenť
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfActivity#getAssignmentCount()
	 */
	public int getAssignmentCount() throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * Ǘׂ̂ẴvZXԂB
	 *
	 * @return vZX
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfRequester#getAllPerformers()
	 */
	public WfProcess[] getAllPerformers() throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * CfNXŎw肳ꂽvZXԂB
	 *
	 * @param index CfNX
	 * @return vZX
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfRequester#getPerformer(int)
	 */
	public WfProcess getPerformer(int index) throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * ǗĂvZX̌ԂB
	 *
	 * @return vZX̌
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfRequester#getPerformerCount()
	 */
	public int getPerformerCount() throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * ̎sIuWFNgɊւύX擾B
	 *
	 * @return ύX
	 * @throws HistoryNotAvailableException ύX擾\łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getAllHistories()
	 */
	public WfEvent[] getAllHistories()
	throws HistoryNotAvailableException, WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * CfNXw肵āA擾B
	 *
	 * @param index CfNX
	 * @return ύX
	 * @throws HistoryNotAvailableException ύX擾\łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getHistory(int)
	 */
	public WfEvent getHistory(int index)
	throws HistoryNotAvailableException, WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * ύX̐ԂB
	 *
	 * @return ύX̐
	 * @throws HistoryNotAvailableException ύX擾\łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#getHistoryCount()
	 */
	public int getHistoryCount()
	throws HistoryNotAvailableException, WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * w肳ꂽATCgÃANeBreBɊ蓖Ăꂽ̂ǂԂB
	 *
	 * @param ass WfAssignment
	 * @return ̃ANeBreBɊ蓖Ăꂽ̂łꍇtrue
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfActivity#isMemberOfAssignment(jp.co.argo21.nautica.workflow.omg.WfAssignment)
	 */
	public boolean isMemberOfAssignment(WfAssignment ass)
	throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * Ŏw肳ꂽvZXAǗɂ邩ǂԂB
	 *
	 * @param proc vZX
	 * @return Ǘɂꍇtrue
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfRequester#isMemberOfPerformer(jp.co.argo21.nautica.workflow.omg.WfProcess)
	 */
	public boolean isMemberOfPerformer(WfProcess proc) throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * ڍ׏ݒ肷B
	 *
	 * @param desc ڍ׏
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#setDescription(java.lang.String)
	 */
	public void setDescription(String desc)
	throws WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * WfActivityɂĕ\Ƃ̎sɂĐ錋ʂݒ肷B
	 *
	 * @param result sʂݒ肷B
	 * @throws InvalidDataException ȃf[^̏ꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfActivity#setResult(jp.co.argo21.nautica.workflow.omg.WfNameValue[])
	 */
	public void setResult(WfNameValue[] result)
	throws InvalidDataException, WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * sIuWFNgɂ鑮ꗗݒ肷B
	 *
	 * @param context ꗗ
	 * @throws InvalidDataException ȑ̏ꍇ 
	 * @throws UpdateNotAllowedException XVłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#setContext(jp.co.argo21.nautica.workflow.omg.WfNameValue[])
	 */
	public void setContext(WfNameValue[] context)
	throws InvalidDataException, UpdateNotAllowedException, WorkflowException
	{
		try {
			if (context == null) {
				// vZXϐnullłB
				String E0079 = StringManager.get("E0079");
				throw new InvalidDataException(E0079);
			}
			
			String aid = activity.getActivityID();

			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			VariableDAO variableDAO = daoFactory.getVariableDAO();
			Timestamp ts = DataAccessManager.getAccessTime();
			
			for (int i = 0; i < context.length; i++) {
				if (context[i] instanceof Attribute == false) {
					// vZXϐł͂܂B
					String E0078 = StringManager.get("E0078");
					throw new InvalidDataException(E0078);
				}
				Attribute attr = (Attribute)context[i];
				VariableBean bean = new VariableBean();
				bean.setName(attr.getName());
				bean.setType(attr.getType());
				bean.setValue(attr.getValue());
				VariableBean check = variableDAO.findByPrimaryKey(
						bean.getProcessID(), bean.getID());
				if (check == null) {
					bean.setProcessID(activity.getProcessID());
					bean.setUpdateDate(ts);
					bean.setID(UniqueKeyGenerator.generate(VariableBean.ID_PREFIX));
					variableDAO.insert(bean, aid);
				} else {
					variableDAO.update(check, bean.getValue(), aid, ts);
				}
			}
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐ̐ݒɎs܂B
			String E0080 = StringManager.get("E0080");
			throw new WorkflowException(E0080, ex);
		}
	}

	/**
	 * sIuWFNgɂ鑮ݒ肷B
	 *
	 * @param context 
	 * @throws InvalidDataException ȑ̏ꍇ 
	 * @throws UpdateNotAllowedException XVłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#setContext(jp.co.argo21.nautica.workflow.omg.WfNameValue[])
	 */
	public void setContext(WfNameValue context)
	throws InvalidDataException, UpdateNotAllowedException, WorkflowException
	{
		try {
			if (context == null) {
				// vZXϐnullłB
				String E0079 = StringManager.get("E0079");
				throw new InvalidDataException(E0079);
			}
			
			String aid = activity.getActivityID();

			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			VariableDAO variableDAO = daoFactory.getVariableDAO();
			Timestamp ts = DataAccessManager.getAccessTime();
			
			if (context instanceof Attribute == false) {
				// vZXϐł͂܂B
				String E0078 = StringManager.get("E0078");
				throw new InvalidDataException(E0078);
			}
			Attribute attr = (Attribute)context;
			VariableBean bean = new VariableBean();
			bean.setName(attr.getName());
			bean.setType(attr.getType());
			bean.setValue(attr.getValue());
			VariableBean check = variableDAO.findByName(
					activity.getProcessID(), bean.getName());
			if (check == null) {
				bean.setProcessID(activity.getProcessID());
				bean.setUpdateDate(ts);
				bean.setID(UniqueKeyGenerator.generate(VariableBean.ID_PREFIX));
				variableDAO.insert(bean, aid);
			} else {
				variableDAO.update(check, bean.getValue(), aid, ts);
			}
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐ̐ݒɎs܂B
			String E0080 = StringManager.get("E0080");
			throw new WorkflowException(E0080, ex);
		}
	}

	/**
	 * w肳ꂽԂɑJڂ݂B
	 *
	 * @param state 
	 * @throws InvalidStateException ȏԂ̏ꍇ
	 * @throws TransitionNotAllowedException w肳ꂽԂɑJڂłȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#changeState(jp.co.argo21.nautica.workflow.omg.WfState)
	 */
	public void changeState(WfState state)
	throws InvalidStateException, TransitionNotAllowedException, WorkflowException
	{
		if (state instanceof ActivityState == false) {
			// ANeBreBԂł͂܂B
			String E0081 = StringManager.get("E0081");
			throw new InvalidStateException(E0081);
		}

		if (ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
			// ̃ANeBreBԂɂ͑Jڂł܂B
			String E0082 = StringManager.get("E0082") + "(" + state.toString() + ")";
			throw new TransitionNotAllowedException(E0082);
		} else if (ActivityState.OPEN_NOT_RUNNING_SUSPENDED.equals(state)) {
			suspend();
		} else if (ActivityState.OPEN_RUNNING.equals(state)) {
			if (ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.equals(getState())) {
				start();
			} else {
				resume();
			}
		} else if (ActivityState.CLOSED_COMPLETED.equals(state)) {
			complete();
		} else if (ActivityState.CLOSED_TERMINATED.equals(state)) {
			terminate();
		} else if (ActivityState.CLOSED_ABORTED.equals(state)) {
			abort();
		}
	}

	/**
	 * ANeBreB̊JnsB
	 *
	 * @throws CannotStartException JnłȂꍇ
	 * @throws AlreadyRunningException łɊJnĂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void start()
	throws CannotStartException, AlreadyRunningException, WorkflowException
	{
		try {
			ActivityState state = (ActivityState)getState();
			boolean closedAlready = false;
			if (ActivityState.CLOSED_COMPLETED.equals(state)
					|| ActivityState.CLOSED_TERMINATED.equals(state)
					|| ActivityState.CLOSED_ABORTED.equals(state)) {
				closedAlready = true;
			} else if (ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state) == false) {
				//Ō^ɂċʂ
				//throw new AlreadyRunningException("");
			}

			String pid = activity.getProcessID();
			String aid = activity.getActivityID();
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
			
			ProcessBean pbean = proc.getBean();
			String pdid = pbean.getProcDefinitionID();
			
			String adid = activity.getActivityDefinitionID();

			//ΉvZX`̎擾
			WorkflowEngine engine = WorkflowEngine.getInstance();
			DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
			ProcessDefinition pd = rep.getProcessDefinition(pdid);
			
			//ANeBreB`̒T
			ActivityDefinition ad = findActivity(pd, adid);
			String type = ad.getType();
			
			if (closedAlready) {
				//ÎݗOԂAIB
				if (type.equals(ActivityDefinition.CONCUR_END) == false) {
					// ANeBreB͂łɎsIĂ܂B
					String E0085 = StringManager.get("E0085");
					throw new NotRunningException(E0085);
				} else {
					return;
				}
			} else if (ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state) == false) {
				//ÎݗOԂAIB
				if (type.equals(ActivityDefinition.CONCUR_END) == false) {
					// ANeBreB͂łɊJnĂ܂B
					String E0083 = StringManager.get("E0083");
					throw new AlreadyRunningException(E0083);
				}
			}
			
			//ANeBreB̎ނɉʂ̏s
			ActivityBehaviorFactory abf = ActivityBehaviorFactory.getInstance();
			ActivityBehavior behavior = abf.getActivityBehavior(ad.getType());
			BehaviorExecutor.start(behavior, pd, ad, proc, this);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreBJnł܂łB
			String E0087 = StringManager.get("E0087");
			throw new WorkflowException(E0087, ex);
		}
	}

	/**
	 * ۗ̎sIuWFNg̍ĊJvB
	 * v󂯓ꂽꍇAԂ́Aopen.not_running.suspendedA
	 * open.runningɐݒ肳B
	 *
	 * @throws CannotResumeException ĊJłȂꍇ 
	 * @throws NotRunningException słȂꍇ
	 * @throws NotSuspendedException ۗĂȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#resume()
	 */
	public void resume()
	throws CannotResumeException, NotRunningException,
		NotSuspendedException, WorkflowException
	{
		try {
			ActivityState state = (ActivityState)getState();
			
			if (ActivityState.CLOSED_COMPLETED.equals(state)
					|| ActivityState.CLOSED_TERMINATED.equals(state)
					|| ActivityState.CLOSED_ABORTED.equals(state)) {
				// ANeBreB͂łɎsIĂ܂B
				String E0085 = StringManager.get("E0085");
				throw new NotRunningException(E0085);
			} else if (ActivityState.OPEN_NOT_RUNNING_SUSPENDED.equals(state) == false) {
				// ANeBreB͕ۗĂ܂B
				String E0086 = StringManager.get("E0086");
				throw new NotSuspendedException(E0086);
			}

			String pid = activity.getProcessID();
			String aid = activity.getActivityID();
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
			
			ProcessBean pbean = proc.getBean();
			String pdid = pbean.getProcDefinitionID();
			
			String adid = activity.getActivityDefinitionID();

			//ΉvZX`̎擾
			WorkflowEngine engine = WorkflowEngine.getInstance();
			DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
			ProcessDefinition pd = rep.getProcessDefinition(pdid);
			
			//ANeBreB`̒T
			ActivityDefinition ad = findActivity(pd, adid);
			
			//ANeBreB̎ނɉsB
			String type = ad.getType();
			ActivityBehaviorFactory abf = ActivityBehaviorFactory.getInstance();
			ActivityBehavior behavior = abf.getActivityBehavior(ad.getType());
			BehaviorExecutor.resume(behavior, pd, ad, proc, this);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreBĊJł܂łB
			String E0088 = StringManager.get("E0088");
			throw new WorkflowException(E0088, ex);
		}
	}

	/**
	 * s̎sIuWFNg̒~vB
	 * v󂯓ꂽꍇAԂclosed.terminatedɐݒ肳B
	 *
	 * @throws CannotStopException ~łȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#suspend()
	 */
	public void suspend()
	throws CannotSuspendException, NotRunningException,
		AlreadySuspendedException, WorkflowException
	{
		try {
			ActivityState state = (ActivityState)getState();
			
			if (ActivityState.CLOSED_COMPLETED.equals(state)
					|| ActivityState.CLOSED_TERMINATED.equals(state)
					|| ActivityState.CLOSED_ABORTED.equals(state)) {
				// ANeBreB͂łɎsIĂ܂B
				String E0085 = StringManager.get("E0085");
				throw new NotRunningException(E0085);
			} else if (ActivityState.OPEN_NOT_RUNNING_SUSPENDED.equals(state)) {
				// ANeBreB͂łɕۗĂ܂B
				String E0084 = StringManager.get("E0084");
				throw new AlreadySuspendedException(E0084);
			}
			String pid = activity.getProcessID();
			String aid = activity.getActivityID();
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
			
			ProcessBean pbean = proc.getBean();
			String pdid = pbean.getProcDefinitionID();
			
			String adid = activity.getActivityDefinitionID();

			//ΉvZX`̎擾
			WorkflowEngine engine = WorkflowEngine.getInstance();
			DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
			ProcessDefinition pd = rep.getProcessDefinition(pdid);
			
			//ANeBreB`̒T
			ActivityDefinition ad = findActivity(pd, adid);
			
			//ANeBreB̎ނɉsB
			String type = ad.getType();
			ActivityBehaviorFactory abf = ActivityBehaviorFactory.getInstance();
			ActivityBehavior behavior = abf.getActivityBehavior(ad.getType());
			BehaviorExecutor.suspend(behavior, pd, ad, proc, this);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreBۗł܂łB
			String E0089 = StringManager.get("E0089");
			throw new WorkflowException(E0089, ex);
		}
	}

	/**
	 * WfActivitẙv邽߂ɁAAvP[VɂĎgpB
	 * ́AsetResult()ƋɁAANeBreB̌ʂvZXɕԂ߂ɎgpB
	 *
	 * @throws CannotCompleteException łȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void complete()
	throws CannotStopException, NotRunningException, WorkflowException
	{
		try {
			boolean closedAlready = false;
			ActivityState state = (ActivityState)getState();
			
			if (ActivityState.CLOSED_COMPLETED.equals(state)
					|| ActivityState.CLOSED_TERMINATED.equals(state)
					|| ActivityState.CLOSED_ABORTED.equals(state)) {
				closedAlready = true;
			}
			
			//YANeBreBB
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ActivityDAO actDAO = daoFactory.getActivityDAO();
			Timestamp ts = DataAccessManager.getAccessTime();
			if (closedAlready) {
				//łɂق̗vɂ芮Ă邽߁A
				//Ԃ͕ύXɓt݂̂XVB
				actDAO.updateDate(getBean(), ts);
			} else {
				//vZX̎擾
				String pid = activity.getProcessID();
				ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
				ProcessManager pm = pmf.getOwnerProcessManager(pid);
				ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);

				ProcessBean pbean = proc.getBean();
				String pdid = pbean.getProcDefinitionID();
				String adid = activity.getActivityDefinitionID();

				//ΉvZX`̎擾
				WorkflowEngine engine = WorkflowEngine.getInstance();
				DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
				ProcessDefinition pd = rep.getProcessDefinition(pdid);
				
				//ANeBreB`̒T
				ActivityDefinition ad = findActivity(pd, adid);
				
				//ANeBreB̎ނɉsB
				String type = ad.getType();
				ActivityBehaviorFactory abf = ActivityBehaviorFactory.getInstance();
				ActivityBehavior behavior = abf.getActivityBehavior(ad.getType());
				BehaviorExecutor.complete(behavior, pd, ad, proc, this);
			}
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreBł܂łB
			String E0090 = StringManager.get("E0090");
			throw new WorkflowException(E0090, ex);
		}
	}

	/**
	 * s̎sIuWFNg̒~vB
	 * v󂯓ꂽꍇAԂclosed.terminatedɐݒ肳B
	 *
	 * @throws CannotStopException ~łȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#terminate()
	 */
	public void terminate()
	throws CannotStopException, NotRunningException, WorkflowException
	{
		terminate(true);
	}

	/**
	 * ۗꂽsIuWFNg̒fvB
	 * v󂯓ꂽꍇAԂclosed.abortedɐݒ肳B
	 *
	 * @throws CannotStopException ~łȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfExecutionObject#abort()
	 */
	public void abort()
	throws CannotStopException, NotRunningException, WorkflowException
	{
		abort(true);
	}

	/**
	 * WfProcess̃NGX^Ƀ[Nt[Cxgʒm邽߂
	 * gp郊Xi[C^tF[XB̃C^tF[XʂāA
	 * WfProcesśA(complete)A~(terminate)Af(abort)̃CxgA
	 * N[Yh(closed)Ԃւ̑JڂNGX^ɒʒm̂ƂB
	 *
	 * @param event Cxg
	 * @throws InvalidPerformerException ȃvZX̏ꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfRequester#receiveEvent(jp.co.argo21.nautica.workflow.omg.WfEvent)
	 */
	public void receiveEvent(WfEvent event)
	throws InvalidPerformerException, WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * tB^[œ肳ꂽvZXϐԂB
	 *
	 * @param filter tB^[
	 * @return vZXϐ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	WfNameValue[] getContext(Filter filter) throws WorkflowException
	{
		try {
			String sqlPart = new VariableFilterConverter().convertToSQL(filter);
			WorkflowDAOFactory daoFactory
				= DataAccessManager.getDAOFactory();
			VariableDAO variableDAO = daoFactory.getVariableDAO();
			
			VariableBean[] beans = variableDAO.findBySQLPart(activity.getProcessID(), sqlPart);
			
			return beans;
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// vZXϐ̎擾Ɏs܂B
			String E0032 = StringManager.get("E0032");
			throw new WorkflowException(E0032, ex);
		}
	}

	/**
	 * ɕێĂANeBreBԂB
	 *
	 * @return ANeBreB
	 */
	ActivityBean getBean()
	{
		return (ActivityBean)activity;
	}

	/**
	 * ~sBfalsȅꍇ́ATuvZX`FbNȂB
	 *
	 * @param checkChild TuvZX`FbN邩ǂtO
	 * @throws CannotStopException ~łȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	void terminate(boolean checkChild)
	throws CannotStopException, NotRunningException, WorkflowException
	{
		try {
			boolean closedAlready = false;
			ActivityState state = (ActivityState)getState();
			
			if (ActivityState.CLOSED_COMPLETED.equals(state)
					|| ActivityState.CLOSED_TERMINATED.equals(state)
					|| ActivityState.CLOSED_ABORTED.equals(state)) {
				closedAlready = true;
			}
			
			//YANeBreB𒆎~B
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ActivityDAO actDAO = daoFactory.getActivityDAO();
			Timestamp ts = DataAccessManager.getAccessTime();
			if (closedAlready) {
				//łɂق̗vɂ芮Ă邽߁A
				//Ԃ͕ύXɓt݂̂XVB
				actDAO.updateDate(getBean(), ts);
			} else {
				//vZX̎擾
				String pid = activity.getProcessID();
				ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
				ProcessManager pm = pmf.getOwnerProcessManager(pid);
				ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);

				ProcessBean pbean = proc.getBean();
				String pdid = pbean.getProcDefinitionID();
				String adid = activity.getActivityDefinitionID();

				//ΉvZX`̎擾
				WorkflowEngine engine = WorkflowEngine.getInstance();
				DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
				ProcessDefinition pd = rep.getProcessDefinition(pdid);
				
				//ANeBreB`̒T
				ActivityDefinition ad = findActivity(pd, adid);
				
				//ANeBreB̎ނɉsB
				String type = ad.getType();
				ActivityBehaviorFactory abf = ActivityBehaviorFactory.getInstance();
				ActivityBehavior behavior = abf.getActivityBehavior(ad.getType());
				BehaviorExecutor.terminate(behavior, pd, ad, proc, this, checkChild);
			}
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreB~ł܂łB
			String E0091 = StringManager.get("E0091");
			throw new WorkflowException(E0091, ex);
		}
	}

	/**
	 * ~sBfalsȅꍇ́ATuvZX`FbNȂB
	 *
	 * @param checkChild TuvZX`FbN邩ǂtO
	 * @throws CannotStopException ~łȂꍇ
	 * @throws NotRunningException słȂꍇ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	void abort(boolean checkChild)
	throws CannotStopException, NotRunningException, WorkflowException
	{
		try {
			boolean closedAlready = false;
			ActivityState state = (ActivityState)getState();
			
			if (ActivityState.CLOSED_COMPLETED.equals(state)
					|| ActivityState.CLOSED_TERMINATED.equals(state)
					|| ActivityState.CLOSED_ABORTED.equals(state)) {
				closedAlready = true;
			}
			
			//YANeBreB𒆎~B
			WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
			ActivityDAO actDAO = daoFactory.getActivityDAO();
			Timestamp ts = DataAccessManager.getAccessTime();
			//vZX̎擾
			String pid = activity.getProcessID();
			if (closedAlready) {
				//łɂق̗vɂ芮Ă邽߁A
				//Ԃ͕ύXɓt݂̂XVB
				actDAO.updateDate(getBean(), ts);
			} else {
				ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
				ProcessManager pm = pmf.getOwnerProcessManager(pid);
				ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);

				ProcessBean pbean = proc.getBean();
				String pdid = pbean.getProcDefinitionID();
				String adid = activity.getActivityDefinitionID();

				//ΉvZX`̎擾
				WorkflowEngine engine = WorkflowEngine.getInstance();
				DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
				ProcessDefinition pd = rep.getProcessDefinition(pdid);
				
				//ANeBreB`̒T
				ActivityDefinition ad = findActivity(pd, adid);
				
				//ANeBreB̎ނɉsB
				String type = ad.getType();
				ActivityBehaviorFactory abf = ActivityBehaviorFactory.getInstance();
				ActivityBehavior behavior = abf.getActivityBehavior(ad.getType());
				BehaviorExecutor.abort(behavior, pd, ad, proc, this, checkChild);
			}

			//bZ[WL[ɃvZXvo^
			WorkflowMessage eprmsg = new EndProcessRequestMessage(pid, ActivityState.CLOSED_ABORTED);
			SystemMessageTransporter mt = new SystemMessageTransporter(EndProcessRequestWatcher.NAME);
			mt.sendMessage(eprmsg);
		} catch (WorkflowException ex) {
			throw ex;
		} catch (Exception ex) {
			// ANeBreB𒆎~ł܂łB
			String E0092 = StringManager.get("E0092");
			throw new WorkflowException(E0092, ex);
		}
	}
	
	/**
	 * 񂩂肳ANeBreB`ԂB
	 *
	 * @param pd vZX`
	 * @param adid ANeBreB`ID
	 * @return ANeBreB`
	 * @throws Exception Cӂ̗O
	 */
	private ActivityDefinition findActivity(ProcessDefinition pd, String adid)
	throws Exception
	{
		List acts = pd.getActivities();
		Iterator it = acts.iterator();
		
		ActivityDefinition ad = null;
		while (it.hasNext()) {
			ActivityDefinition def = (ActivityDefinition)it.next();
			if (def.getID().equals(adid)) {
				ad = def;
				break;
			}
		}
		
		if (ad == null) {
			// ΉANeBreB`݂܂B
			String E0093 = StringManager.get("E0093") + "(" + adid + ")";
			throw new WorkflowException(E0093);
		}
		return ad;
	}
}
