/* $Id: AssignmentEventObject.java,v 1.7 2005/08/26 04:53:07 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.omg.WfAssignmentEvent;
import jp.co.argo21.nautica.workflow.omg.WfExecutionObject;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * 蓖ăCxg\B̃NX́A݊̂߂ɗpӂĂ邾
 * ݂̃GWł͎gĂȂB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class AssignmentEventObject extends WorkflowEventObject
implements WfAssignmentEvent
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** \[XID */
	private String oldResourceID;
	
	/**  \[X */
	private String oldResourceName;
	
	/** V\[XID */
	private String newResourceID;
	
	/** V\[X */
	private String newResourceName;
	
	/**
	 * 蓖ăCxg𐶐B
	 *
	 * @param type Cxg̎
	 * @param source CxgNWfExecutionObject
	 * @param timestamp Cxg
	 * @param processManagerName vZX}l[W
	 * @param processManagerVersion vZX}l[W̃o[W
	 * @param processID vZXID
	 * @param processName vZX
	 * @param activityID ANeBreBID
	 * @param activityName ANeBreB
	 * @param oldResourceID \[XID
	 * @param oldResourceName \[X
	 * @param newResourceID V\[XID
	 * @param newResourceName V\[X
	 */
	public AssignmentEventObject(String type, WfExecutionObject source,
			String timestamp, String processManagerName,
			String processManagerVersion, String processID, String processName,
			String activityID, String activityName, String oldResourceID,
			String oldResourceName, String newResourceID, String newResourceName)
	{
		super(type, source, timestamp, processManagerName,
				processManagerVersion, processID, processName, activityID,
				activityName);
		this.oldResourceID = oldResourceID;
		this.oldResourceName = oldResourceName;
		this.newResourceID = newResourceID;
		this.newResourceName = newResourceName;
	}

	/**
	 * \[XIDԂB
	 *
	 * @return \[XID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfAssignmentEvent#getOldResourceID()
	 */
	public String getOldResourceID() throws WorkflowException
	{
		return oldResourceID;
	}

	/**
	 * \[XԂB
	 *
	 * @return \[X
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfAssignmentEvent#getOldResourceName()
	 */
	public String getOldResourceName() throws WorkflowException
	{
		return oldResourceName;
	}

	/**
	 * V\[XIDԂB
	 *
	 * @return \[XID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfAssignmentEvent#getNewResourceID()
	 */
	public String getNewResourceID() throws WorkflowException
	{
		return newResourceID;
	}

	/**
	 * V\[XԂB
	 *
	 * @return \[X
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.omg.WfAssignmentEvent#getNewResourceName()
	 */
	public String getNewResourceName() throws WorkflowException
	{
		return newResourceName;
	}
}
