/* $Id: AuditDataRecord.java,v 1.3 2005/08/26 04:53:06 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import jp.co.argo21.nautica.workflow.wfmc.Attribute;

/**
 * čȌێNXB
 * čÓACWADړAf[^vf(CxgƂɈقȂ)ACWADڔ琬B
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class AuditDataRecord {
    
    private AuditPrefix prefix;
    private AuditSuffix suffix;
    private Map elements = new HashMap();
    
    /**
     * CWADړCWADڔݒ肷B
     * 
     * @param prefix CWADړ
     * @param suffix CWADڔ
     */
    AuditDataRecord(AuditPrefix prefix, AuditSuffix suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }
    
    /**
     * čÕf[^vfݒ肷B
     * 
     * @param name  vf
     * @param value l
     */
    void setDataElement(String name, String value) {
        elements.put(name, value);
    }
    
    /**
     * čÕf[^vfݒ肷B
     * 
     * @param name  vf
     * @param value l
     */
    void setDataElement(String name, int value) {
        elements.put(name, Integer.toString(value));
    }
    
    /**
     * čÕf[^vfݒ肷B
     * l null ̏ꍇ́AƂ "NULL" ZbgB
     * 
     * @param name  vf
     * @param value l
     */
    void setDataElement(String name, Object value) {
        if (value == null) {
            setDataElement(name, "NULL");
        } else {
            setDataElement(name, value.toString());
        }
    }
    
    /**
     * čÕf[^vfƂāAz񒆂̃vZXCX^X
     * ̖OA^Alݒ肷B
     * 
     * @param attrs Attributez
     */
    void setDataElement(Attribute[] attrs) {
        if (attrs != null) {
            for (int i = 0; i < attrs.length; i++) {
                setDataElement("AttributeName" + i, attrs[i].getName());
				setDataElement("AttributeType" + i, attrs[i].getType());
				setDataElement("Attributevalue" + i, attrs[i].getValue());
            }
        }
    }
    
    /**
     * čO̕\ԂB
     * 
     * @return čO
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = elements.keySet().iterator();
        String key = "";
        String value = "";
        while (iter.hasNext()) {
            key = (String) iter.next();
            value = (String) elements.get(key);
            sb.append("(" + key + " = " + value + ")");
        }
                
        return prefix + sb.toString() + suffix;        
    }
}