/* $Id: AuditPrefix.java,v 1.4 2005/08/26 04:53:26 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.security.SessionManager;

/**
 * čO̐ړ(prefix)̏ێNXB
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class AuditPrefix {
    /** InitialProcessInstanceID (ftHg = argo21) */
    private static final String INITIAL_PI_ID = "argo21";

    /** DomainID (ftHg = nautica) */
    private static final String DOMAIN_ID = "nautica";
    
    /** NodeID (ftHg = nautica.properties  nautica.workflow.scope ̒l) */
    private static final String NODE_ID
    = System.getProperty(WorkflowEngineConstants.NAUTICA_SCOPE);    
    
    /** CurrentProcessInstanceID */
    private String currentPI = "";
    
    /** ProcessState */
    private String state = "";
    
    /** EventCode */
    private String eventcode = "";
        
    /** UserID */
    private String userID = "";

    /** InformationID (ftHg = WfMC) */
    private String infoID = "WfMC";    
    
    /**
     * ݂̃vZXCX^XIDAvZXCX^X̏ԁA
     * [UIDݒ肷B[UID́AZbVIDpĎ擾B
     * 
     * @param currentPI ݂̃vZXCX^XID
     * @param eventcode CxgR[h
     * @param sid ZbVID
     */
    AuditPrefix(String currentPI, String eventcode, String sid) {
        this.currentPI = currentPI;
        this.eventcode = eventcode;
        
        if (sid == null || sid.trim().equals("")) {
            return;
        }
        
        /* ZbVID烆[UID擾Aݒ */
        SessionManagerFactory factory = SessionManagerFactory.getInstance();
		SessionManager manager = factory.getSessionManager();
        try {
            this.userID = manager.getSessionUser(sid).getID();
        } catch (Exception e) {
            /* Ignore */
        }
    }    
    
    /**
     * vZXCX^XIDACxgR[hݒ肷B
     * 
     * @param currentPI vZXCX^XID
     * @param eventcode CxgR[h
     */
    AuditPrefix(String currentPI, String eventcode) {
        this.currentPI = currentPI;
        this.eventcode = eventcode;
    }
    
    /**
     * CxgR[hݒ肷B
     * 
     * @param eventcode CxgR[h
     */
    AuditPrefix(String eventcode) {
        this.eventcode = eventcode;
    }
    
    /**
     * ftHgRXgN^
     */
    AuditPrefix() {
        // Ȃ
    }
    
    /**
     * ݂̃vZXCX^XIDݒ肷B
     * 
     * @param currentPI vZXCX^XID
     */
    void setCurrentPI(String currentPI) {
        this.currentPI = currentPI;
    }
    
    /**
     * vZXCX^X݂̌̏Ԃݒ肷B
     * 
     * @param state 
     */
    void setState(String state) {
        this.state = state;
    }
    
    /**
     * CxgR[hݒ肷B
     * 
     * @param eventcode CxgR[h
     */
    void setEventCode(String eventcode) {
        this.eventcode = eventcode;
    }
    
    /**
     * [UIDݒ肷B
     * 
     * @param userID [UID
     */
    void setUserID(String userID) {
        this.userID = userID;
    }
        
    /**
     * IDݒ肷B
     * ID̃ftHgl WfMC łB
     * 
     * @param infoID ID
     */
    void setInfoID(String infoID) {
        this.infoID = infoID;
    }
    
    /**
     * CWADړ̕\ԂB
     * 
     * @return CWADړ
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(InitialProcessInstanceID="+ INITIAL_PI_ID + ")");
        sb.append("(DomainID=" + DOMAIN_ID + ")");
        sb.append("(NodeID=" + NODE_ID + ")");
        sb.append("(CurrentProcessInstanceID=" + currentPI + ")");
        sb.append("(ProcessState=" + state + ")");
        sb.append("(EventCode=" + eventcode + ")");
        sb.append("(UserID=" + userID + ")");
        sb.append("(InformationID=" + infoID + ")");
        
        return sb.toString();
    }
}