/* $Id: BehaviorExecutor.java,v 1.3 2005/08/26 04:53:20 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;

/**
 * ANeBreBrIɎss߃NXB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
final class BehaviorExecutor
{
	/**
	 * JnsB
	 *
	 * @param behavior ANeBreB
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	public static synchronized void start(ActivityBehavior behavior,
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		behavior.start(pd, ad, proc, act);
	}
	
	/**
	 * ۗsB
	 *
	 * @param behavior ANeBreB
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	public static synchronized void suspend(ActivityBehavior behavior,
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		behavior.suspend(pd, ad, proc, act);
	}
	
	/**
	 * ĊJsB
	 *
	 * @param behavior ANeBreB
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @throws Exception
	 */
	public static synchronized void resume(ActivityBehavior behavior,
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		behavior.resume(pd, ad, proc, act);
	}
	
	/**
	 * sB
	 *
	 * @param behavior ANeBreB
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	public static synchronized void complete(ActivityBehavior behavior,
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		behavior.complete(pd, ad, proc, act);
	}

	/**
	 * ~sB
	 *
	 * @param behavior ANeBreB
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	public static synchronized void abort(ActivityBehavior behavior,
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, boolean checkChild)
	throws Exception
	{
		behavior.abort(pd, ad, proc, act, checkChild);
	}
	
	/**
	 * ~sB
	 *
	 * @param behavior ANeBreB
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	public static synchronized void terminate(ActivityBehavior behavior,
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, boolean checkChild)
	throws Exception
	{
		behavior.terminate(pd, ad, proc, act, checkChild);
	}
}
