/* $Id: ConcurrentEndActivityBehavior.java,v 1.14 2005/08/26 04:53:42 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockBean;
import jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;

/**
 * sIANeBreB̏ԂƂ̓`NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.14 $
 * @since   Nautica Workflow 0.9
 */
public class ConcurrentEndActivityBehavior
extends AbstractActivityBehavior
{
	/**
	 * sIANeBreB̏ԂƂ̓𐶐B
	 */
	public ConcurrentEndActivityBehavior()
	{
		super();
	}

	/**
	 * ŗL̒~sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#abort(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal, boolean)
	 */
	public void abort(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, boolean checkChild)
	throws Exception
	{
		ActivityBean abean = act.getBean();
		String pid = abean.getProcessID();
		String bid = abean.getBlockID();

		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		
		ConcurrencyBlockDAO cbDAO = daoFactory.getConcurrencyBlockDAO();
		//̃ubN폜B
		cbDAO.delete(pid, bid);
		
		//YANeBreB𒆒fB
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.CLOSED_ABORTED, ts);
	}

	/**
	 * ŗL̊sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#complete(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal)
	 */
	public void complete(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		ProcessBean pbean = proc.getBean();
		String pid = pbean.getID();
		ActivityBean abean = act.getBean();
		String bid = abean.getBlockID();

		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		VariableDAO varDAO = daoFactory.getVariableDAO();
		List vars = varDAO.findByProcessIDAsList(pid);
		List trs = ConditionEvaluator.evaluate(pd, ad, vars, false);
		
		ConcurrencyBlockDAO cbDAO = daoFactory.getConcurrencyBlockDAO();
		ConcurrencyBlockBean cbbean = cbDAO.findByPrimaryKey(pid, bid);
		String ubid = cbbean.getUpperBlockID();
		//̃ubN폜B
		cbDAO.delete(pid, bid);
		
		Iterator it = trs.iterator();
		List acts = new ArrayList();
		while (it.hasNext()) {
			TransitionDefinition tr = (TransitionDefinition)it.next();
			ActivityDefinition dest = tr.getDestination();
			
			//JڐANeBreB̐
			//ޔĂubNID𕜋AĂ
			ActivityBean ab = createActivity(pd, dest, pbean, ubid);
			acts.add(ab);
		}
		
		if (acts.size() == 0) {
			//Jڐ悪ȂB`~X̉\B
			suspend(pd, ad, proc, act);
			String msg = StringManager.get("F0001");
			eLog.fatal(msg);
			return;
		}
		
		//YANeBreBB
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.CLOSED_COMPLETED, ts);
			
		//JڐANeBreBbZ[WL[ɓo^B
		Iterator ait = acts.iterator();
		while (ait.hasNext()) {
			ActivityBean ab = (ActivityBean)ait.next();
			WorkflowEngine engine = WorkflowEngine.getInstance();
			String aid = ab.getActivityID();
			WorkflowMessage sarmsg = new StartActivityRequestMessage(pid, aid);
			SystemMessageTransporter mt = new SystemMessageTransporter(StartActivityRequestWatcher.NAME);
			mt.sendMessage(sarmsg);
		}
	}

	/**
	 * ŗL̊JnsB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#start(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal)
	 */
	public void start(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		ProcessBean pbean = proc.getBean();
		ActivityBean abean = act.getBean();
		String pid = abean.getProcessID();
		String aid = abean.getActivityID();
		String bid = abean.getBlockID();

		//YANeBreBJnB
		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.OPEN_RUNNING, ts);
		
		ConcurrencyBlockDAO cbDAO = daoFactory.getConcurrencyBlockDAO();
		int actcount = actDAO.findOpeningActivityCountByBlockID(pid, bid);
		int sbcount = cbDAO.findSubblockExistenceByBlockID(pid, bid);
		
		//ubÑANeBreBׂĊꍇ
		if (actcount == 1 && sbcount == 0) {
			//gI[vĂȂ
			//bZ[WL[Ɋvo^
			WorkflowEngine engine = WorkflowEngine.getInstance();
			WorkflowMessage earmsg = new EndActivityRequestMessage(pid, aid);
			SystemMessageTransporter mt = new SystemMessageTransporter(EndActivityRequestWatcher.NAME);
			mt.sendMessage(earmsg);
		}
	}

	/**
	 * ŗL̒~sB
	 *
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param proc vZX
	 * @param act ANeBreB
	 * @throws Exception Cӂ̗O
	 * @see jp.co.argo21.nautica.workflow.engine.ActivityBehavior#terminate(jp.co.argo21.nautica.workflow.definition.ProcessDefinition, jp.co.argo21.nautica.workflow.definition.ActivityDefinition, jp.co.argo21.nautica.workflow.engine.ProcessInternal, jp.co.argo21.nautica.workflow.engine.ActivityInternal, boolean)
	 */
	public void terminate(ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, boolean checkChild)
	throws Exception
	{
		ProcessBean pbean = proc.getBean();
		ActivityBean abean = act.getBean();
		String pid = abean.getProcessID();
		String bid = abean.getBlockID();

		WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
		
		ConcurrencyBlockDAO cbDAO = daoFactory.getConcurrencyBlockDAO();
		ConcurrencyBlockBean cbbean = cbDAO.findByPrimaryKey(pid, bid);
		String ubid = cbbean.getUpperBlockID();
		//̃ubN폜B
		cbDAO.delete(pid, bid);

		VariableDAO varDAO = daoFactory.getVariableDAO();
		List vars = varDAO.findByProcessIDAsList(pid);
		List trs = ConditionEvaluator.evaluate(pd, ad, vars, true);
		
		Iterator it = trs.iterator();
		List acts = new ArrayList();
		while (it.hasNext()) {
			TransitionDefinition tr = (TransitionDefinition)it.next();
			ActivityDefinition dest = tr.getDestination();
			
			//JڐANeBreB̐
			ActivityBean ab = createActivity(pd, dest, pbean, ubid);
			acts.add(ab);
		}
		
		if (acts.size() == 0) {
			//Jڐ悪ȂB`~X̉\B
			suspend(pd, ad, proc, act);
			String msg = StringManager.get("F0001");
			eLog.fatal(msg);
			return;
		}
		
		//YANeBreB𒆎~B
		ActivityDAO actDAO = daoFactory.getActivityDAO();
		Timestamp ts = DataAccessManager.getAccessTime();
		actDAO.updateState(act.getBean(), ActivityState.CLOSED_TERMINATED, ts);

		//JڐANeBreBbZ[WL[ɓo^B
		Iterator ait = acts.iterator();
		while (ait.hasNext()) {
			ActivityBean ab = (ActivityBean)ait.next();
			WorkflowEngine engine = WorkflowEngine.getInstance();
			String aid = ab.getActivityID();
			WorkflowMessage sarmsg = new StartActivityRequestMessage(pid, aid);
			SystemMessageTransporter mt = new SystemMessageTransporter(StartActivityRequestWatcher.NAME);
			mt.sendMessage(sarmsg);
		}
	}
}
