/* $Id: ConditionEvaluator.java,v 1.3 2005/08/26 04:53:09 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.expression.Expression;

/**
 * ]B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
class ConditionEvaluator
{
	/**
	 * ̔sB
	 * 
	 * @param pd vZX`
	 * @param ad ANeBreB`
	 * @param vars	]Ώۂ̃vZXϐ
	 * @param isExRaising	O
	 * @return	]̌ʁAIꂽJ
	 */
	static List evaluate(
			ProcessDefinition pd, ActivityDefinition ad,
			List vars, boolean isExRaising)
	{
		List result = new ArrayList();
		List otherwises = new ArrayList();
		boolean isConcurrent = false;

		if (ad.getType().equals(ActivityDefinition.CONCUR_START)) {
			isConcurrent = true;
		}

		Iterator tit = pd.getTransitions().iterator();
		while (tit.hasNext()) {
			TransitionDefinition tr = (TransitionDefinition)tit.next();

			//YANeBreB̑Jڏł͂ȂꍇAXLbv
			if (ad != tr.getSource()) continue;

			Expression exp = tr.getCondition();
			int type = tr.getType();
			
			if (type == TransitionDefinition.EXCEPTION) {
				if (isExRaising) {
					result.add(tr);
					if (isConcurrent == false) break;
				}
			} else if (type == TransitionDefinition.OTHERWISE) {
				otherwises.add(tr);
			} else {
				if (exp == null) {
					//Ȃꍇ͖JڂƂ݂ȂB
					result.add(tr);
					if (isConcurrent == false) break;
				} else {
					if (exp.eval(vars)) {
						result.add(tr);
						if (isConcurrent == false) break;
					}
				}
			}
		}

		//֑Jڂ̔
		if (result.size() == 0) {
			if (otherwises.size() > 0) {
				if (isConcurrent) {
					result = otherwises;
				} else {
					result.add(otherwises.get(0));
				}
			}
		}

		return result;
	}

}
